/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.scanner;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ErrorProneInjector {
    private final ClassToInstanceMap<Object> instances = MutableClassToInstanceMap.create();

    public static ErrorProneInjector create() {
        return new ErrorProneInjector();
    }

    @CanIgnoreReturnValue
    public <T> ErrorProneInjector addBinding(Class<T> clazz, T instance) {
        this.instances.putInstance(clazz, instance);
        return this;
    }

    public synchronized <T> T getInstance(Class<T> clazz) {
        return this.getInstance(clazz, new ArrayList());
    }

    private synchronized <T> T getInstance(Class<T> clazz, List<Class<?>> path) {
        T newInstance;
        Object instance = this.instances.getInstance(clazz);
        if (instance != null) {
            return (T)instance;
        }
        path.add(clazz);
        Constructor<T> constructor = ErrorProneInjector.findConstructor(clazz).orElseThrow(() -> new ProvisionException("Failed to find an injectable constructor for " + clazz.getCanonicalName() + " requested by " + ErrorProneInjector.printPath(path)));
        constructor.setAccessible(true);
        Object[] args = Arrays.stream(constructor.getParameterTypes()).map(c -> this.getInstance((Class)c, path)).toArray();
        try {
            newInstance = constructor.newInstance(args);
        }
        catch (ReflectiveOperationException e) {
            throw new ProvisionException("Failed to initialize " + clazz.getCanonicalName(), e);
        }
        this.instances.putInstance(clazz, newInstance);
        return newInstance;
    }

    public static <T> Optional<Constructor<T>> findConstructor(Class<T> clazz) {
        return ErrorProneInjector.findConstructorMatching(clazz, c -> Arrays.stream(c.getAnnotations()).anyMatch(a -> a.annotationType().getSimpleName().equals("Inject"))).or(() -> ErrorProneInjector.findConstructorMatching(clazz, c -> c.getParameters().length != 0 && Arrays.stream(c.getParameters()).allMatch(p -> p.getType().equals(ErrorProneFlags.class)))).or(() -> ErrorProneInjector.findConstructorMatching(clazz, c -> c.getParameters().length == 0));
    }

    private static <T> Optional<Constructor<T>> findConstructorMatching(Class<T> clazz, Predicate<Constructor<?>> predicate) {
        return Arrays.stream(clazz.getDeclaredConstructors()).filter(predicate).map(c -> c).findFirst();
    }

    private static String printPath(List<Class<?>> path) {
        return Lists.reverse(path).stream().map(Class::getSimpleName).collect(Collectors.joining(" <- "));
    }

    public static final class ProvisionException
    extends RuntimeException {
        public ProvisionException(String message) {
            super(message);
        }

        public ProvisionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

