/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.SharedDictBase;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;

public class ZstdDictCompress
extends SharedDictBase {
    private long nativePtr = 0L;
    private ByteBuffer sharedDict = null;
    private int level = Zstd.defaultCompressionLevel();

    private native void init(byte[] var1, int var2, int var3, int var4);

    private native void initDirect(ByteBuffer var1, int var2, int var3, int var4, int var5);

    private native void free();

    public ByteBuffer getByReferenceBuffer() {
        return this.sharedDict;
    }

    public ZstdDictCompress(byte[] dict, int level) {
        this(dict, 0, dict.length, level);
    }

    public ZstdDictCompress(byte[] dict, int offset, int length, int level) {
        this.level = level;
        if (dict.length - offset < 0) {
            throw new IllegalArgumentException("Dictionary buffer is to short");
        }
        this.init(dict, offset, length, level);
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createCDict failed");
        }
        this.storeFence();
    }

    public ZstdDictCompress(ByteBuffer dict, int level) {
        this(dict, level, false);
    }

    public ZstdDictCompress(ByteBuffer dict, int level, boolean byReference) {
        this.level = level;
        int length = dict.limit() - dict.position();
        if (!dict.isDirect()) {
            throw new IllegalArgumentException("dict must be a direct buffer");
        }
        if (length < 0) {
            throw new IllegalArgumentException("dict cannot be empty.");
        }
        this.initDirect(dict, dict.position(), length, level, byReference ? 1 : 0);
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("ZSTD_createCDict failed");
        }
        if (byReference) {
            this.sharedDict = dict;
        }
        this.storeFence();
    }

    int level() {
        return this.level;
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            this.free();
            this.nativePtr = 0L;
            this.sharedDict = null;
        }
    }

    static {
        Native.load();
    }
}

