/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.com.google.common.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.checkerframework.errorprone.checker.index.qual.LessThanUnknown;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.errorprone.checker.index.qual.SameLenUnknown;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.errorprone.checker.initialization.qual.Initialized;
import org.checkerframework.errorprone.checker.lock.qual.EnsuresLockHeld;
import org.checkerframework.errorprone.checker.lock.qual.EnsuresLockHeldIf;
import org.checkerframework.errorprone.checker.lock.qual.MayReleaseLocks;
import org.checkerframework.errorprone.checker.lock.qual.ReleasesNoLocks;
import org.checkerframework.errorprone.checker.nullness.qual.NonNull;
import org.checkerframework.errorprone.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.errorprone.checker.signedness.qual.Signed;
import org.checkerframework.errorprone.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.errorprone.common.value.qual.UnknownVal;

abstract class ForwardingLock
implements Lock {
    ForwardingLock() {
    }

    abstract @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Lock delegate();

    @Override
    @EnsuresLockHeld(value={"this"})
    @ReleasesNoLocks
    public void lock() {
        this.delegate().lock();
    }

    @Override
    @EnsuresLockHeld(value={"this"})
    @ReleasesNoLocks
    public void lockInterruptibly() throws @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness InterruptedException {
        this.delegate().lockInterruptibly();
    }

    @Override
    @EnsuresLockHeldIf(expression={"this"}, result=true)
    @ReleasesNoLocks
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness boolean tryLock() {
        return this.delegate().tryLock();
    }

    @Override
    @EnsuresLockHeldIf(expression={"this"}, result=true)
    @ReleasesNoLocks
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness boolean tryLock(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long time, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness TimeUnit unit) throws @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness InterruptedException {
        return this.delegate().tryLock(time, unit);
    }

    @Override
    @MayReleaseLocks
    public void unlock() {
        this.delegate().unlock();
    }

    @Override
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Condition newCondition() {
        return this.delegate().newCondition();
    }
}

