/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.info.ProgramClassOptimizationInfo;

public class PackageVisibleMemberInvokingClassMarker
implements ConstantVisitor,
ClassVisitor,
MemberVisitor {
    private Clazz referencingClass;

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        if (stringConstant.referencedClass != clazz) {
            this.referencingClass = clazz;
            stringConstant.referencedClassAccept((ClassVisitor)this);
            stringConstant.referencedMemberAccept((MemberVisitor)this);
        }
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        if (refConstant.referencedClass != clazz) {
            this.referencingClass = clazz;
            refConstant.referencedClassAccept((ClassVisitor)this);
            refConstant.referencedMemberAccept((MemberVisitor)this);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        if (classConstant.referencedClass != clazz) {
            this.referencingClass = clazz;
            classConstant.referencedClassAccept((ClassVisitor)this);
        }
    }

    public void visitAnyClass(Clazz clazz) {
        if ((clazz.getAccessFlags() & 1) == 0) {
            PackageVisibleMemberInvokingClassMarker.setInvokesPackageVisibleMembers(this.referencingClass);
        }
    }

    public void visitAnyMember(Clazz clazz, Member member) {
        if ((member.getAccessFlags() & 3) == 0) {
            PackageVisibleMemberInvokingClassMarker.setInvokesPackageVisibleMembers(this.referencingClass);
        }
    }

    private static void setInvokesPackageVisibleMembers(Clazz clazz) {
        ProgramClassOptimizationInfo.getProgramClassOptimizationInfo(clazz).setInvokesPackageVisibleMembers();
    }

    public static boolean invokesPackageVisibleMembers(Clazz clazz) {
        return ClassOptimizationInfo.getClassOptimizationInfo(clazz).invokesPackageVisibleMembers();
    }
}

