/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.List;
import java.util.stream.Collectors;

public class StringUtil {
    private static final char TWO_BYTE_LIMIT = '\u0080';
    private static final int TWO_BYTE_CONSTANT1 = 192;
    private static final int TWO_BYTE_CONSTANT2 = 128;
    private static final int TWO_BYTE_SHIFT1 = 6;
    private static final int TWO_BYTE_MASK1 = 31;
    private static final int TWO_BYTE_MASK2 = 63;
    private static final char THREE_BYTE_LIMIT = '\u0800';
    private static final int THREE_BYTE_CONSTANT1 = 224;
    private static final int THREE_BYTE_CONSTANT2 = 128;
    private static final int THREE_BYTE_CONSTANT3 = 128;
    private static final int THREE_BYTE_SHIFT1 = 12;
    private static final int THREE_BYTE_SHIFT2 = 6;
    private static final int THREE_BYTE_MASK1 = 15;
    private static final int THREE_BYTE_MASK2 = 63;
    private static final int THREE_BYTE_MASK3 = 63;

    public static int getModifiedUtf8Length(String string) {
        int byteLength = 0;
        int stringLength = string.length();
        for (int stringIndex = 0; stringIndex < stringLength; ++stringIndex) {
            char c = string.charAt(stringIndex);
            byteLength += c == '\u0000' ? 2 : (c < '\u0080' ? 1 : (c < '\u0800' ? 2 : 3));
        }
        return byteLength;
    }

    public static byte[] getModifiedUtf8Bytes(String string) {
        int byteLength = StringUtil.getModifiedUtf8Length(string);
        int stringLength = string.length();
        byte[] bytes = new byte[byteLength];
        int byteIndex = 0;
        for (int stringIndex = 0; stringIndex < stringLength; ++stringIndex) {
            char c = string.charAt(stringIndex);
            if (c == '\u0000') {
                bytes[byteIndex++] = -64;
                bytes[byteIndex++] = -128;
                continue;
            }
            if (c < '\u0080') {
                bytes[byteIndex++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                bytes[byteIndex++] = (byte)(0xC0 | c >>> 6 & 0x1F);
                bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            bytes[byteIndex++] = (byte)(0xE0 | c >>> 12 & 0xF);
            bytes[byteIndex++] = (byte)(0x80 | c >>> 6 & 0x3F);
            bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
        }
        return bytes;
    }

    public static String getString(byte[] modifiedUtf8Bytes) {
        return StringUtil.getString(modifiedUtf8Bytes, 0, modifiedUtf8Bytes.length);
    }

    public static String getString(byte[] modifiedUtf8Bytes, int startIndex, int endIndex) {
        StringBuilder builder = new StringBuilder(endIndex - startIndex);
        int byteIndex = startIndex;
        while (byteIndex < endIndex) {
            int b = modifiedUtf8Bytes[byteIndex++] & 0xFF;
            try {
                char c = (char)(b < 192 ? b : (b < 224 ? (b & 0x1F) << 6 | modifiedUtf8Bytes[byteIndex++] & 0x3F : (b & 0xF) << 12 | (modifiedUtf8Bytes[byteIndex++] & 0x3F) << 6 | modifiedUtf8Bytes[byteIndex++] & 0x3F));
                builder.append(c);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Missing UTF-8 bytes after byte [0x" + Integer.toHexString(b) + "] in string [" + builder.toString() + "]");
            }
        }
        return builder.toString();
    }

    public static String join(String separator, String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            sb.append(strings[i]);
            if (i + 1 >= strings.length) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String toHexString(byte[] bytes) {
        return StringUtil.toHexString(bytes, null, true);
    }

    public static String toHexString(byte[] bytes, String separator, boolean upperCase) {
        if (bytes == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(2 * bytes.length + (separator == null ? 0 : separator.length() * (bytes.length - 1)));
        for (int index = 0; index < bytes.length; ++index) {
            byte b = bytes[index];
            builder.append(StringUtil.hexNibble(b >> 4, upperCase)).append(StringUtil.hexNibble(b, upperCase));
            if (separator == null || index >= bytes.length - 1) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    private static char hexNibble(int nibble, boolean upperCase) {
        return (char)((nibble &= 0xF) < 10 ? 48 + nibble : (upperCase ? 65 : 97) + nibble - 10);
    }

    public static String escapeControlCharacters(String input) {
        String result = input;
        result = result.replaceAll("\n", "\\\\n");
        result = result.replaceAll("\r", "\\\\r");
        result = result.replaceAll("\t", "\\\\t");
        result = result.replaceAll("\f", "\\\\f");
        result = result.replaceAll("\b", "\\\\b");
        return result;
    }

    public static String listToString(List<String> stringList) {
        return String.format("[%s]", stringList.stream().map(str -> String.format("\"%s\"", str)).collect(Collectors.joining(", ")));
    }
}

