/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HierarchicalWildcardMap<K, V, C> {
    private static final Logger log = LogManager.getLogger(HierarchicalWildcardMap.class);
    private final HashMap<C, Object> maps = new HashMap();
    private final int depth;
    private final Function<K, C[]> disassembler;
    private final C wildcard;

    public HierarchicalWildcardMap(int depth, Function<K, C[]> disassembler, C wildcard) {
        this.depth = depth;
        this.disassembler = disassembler;
        this.wildcard = wildcard;
    }

    public void put(@NotNull K key, @Nullable V value) {
        C[] constituents = this.disassembler.apply(key);
        if (constituents.length != this.depth) {
            throw new IllegalStateException("The provided disassembler function must always return the constituents array with a fixed size of " + this.depth);
        }
        HashMap currentMap = this.maps;
        for (int i = 0; i < this.depth - 1; ++i) {
            currentMap = (HashMap)currentMap.computeIfAbsent(constituents[i], unused -> new HashMap());
        }
        currentMap.put(constituents[this.depth - 1], value);
    }

    @Nullable
    public V get(@NotNull K key) {
        C[] constituents = this.disassembler.apply(key);
        if (constituents.length != this.depth) {
            throw new IllegalStateException("The provided disassembler function must always return the constituents array with a fixed size of " + this.depth);
        }
        return this.getImpl(0, constituents, this.maps);
    }

    @Nullable
    private V getImpl(int currentDepth, C[] keyConstituents, Object currentLevel) {
        if (currentDepth == this.depth) {
            return (V)currentLevel;
        }
        HashMap map = (HashMap)currentLevel;
        if (map == null) {
            return null;
        }
        if (Objects.equals(keyConstituents[currentDepth], this.wildcard)) {
            return this.handleWildcardQuery(currentDepth, keyConstituents, map);
        }
        return this.handleNonWildcardQuery(currentDepth, keyConstituents, map);
    }

    @Nullable
    private V handleNonWildcardQuery(int currentDepth, C[] keyConstituents, HashMap<C, Object> map) {
        Object next = map.get(keyConstituents[currentDepth]);
        @Nullable V result = this.getImpl(currentDepth + 1, keyConstituents, next);
        if (result == null) {
            return this.getImpl(currentDepth + 1, keyConstituents, map.get(this.wildcard));
        }
        return result;
    }

    @Nullable
    private V handleWildcardQuery(int currentDepth, C[] keyConstituents, HashMap<C, Object> map) {
        Object next;
        V result;
        if (map.containsKey(this.wildcard) && (result = this.getImpl(currentDepth + 1, keyConstituents, next = map.get(keyConstituents[currentDepth]))) != null) {
            return result;
        }
        for (Object value : map.values()) {
            @Nullable V result2 = this.getImpl(currentDepth + 1, keyConstituents, value);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public boolean containsKey(@NotNull K key) {
        return this.get(key) != null;
    }
}

