/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class ClassConstantClassFilter
implements ClassVisitor,
ConstantVisitor {
    private final StringMatcher regularExpressionMatcher;
    private final ClassVisitor classVisitor;
    private boolean found;

    public ClassConstantClassFilter(String regularExpression, ClassVisitor classVisitor) {
        this(new ListParser(new ClassNameParser()).parse(regularExpression), classVisitor);
    }

    public ClassConstantClassFilter(StringMatcher regularExpressionMatcher, ClassVisitor classVisitor) {
        this.regularExpressionMatcher = regularExpressionMatcher;
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.found = false;
        programClass.constantPoolEntriesAccept(this);
        if (this.found) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        if (!this.found && this.regularExpressionMatcher.matches(classConstant.getName(clazz))) {
            this.found = true;
        }
    }
}

