/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.datastructure.callgraph;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.analysis.datastructure.CodeLocation;
import proguard.classfile.MethodSignature;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionUtil;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.value.Value;

public abstract class Call {
    private static final Logger log = LogManager.getLogger(Call.class);
    public final CodeLocation caller;
    public final int throwsNullptr;
    public final Instruction instruction;
    public final boolean controlFlowDependent;
    public final boolean runtimeTypeDependent;
    private Value instance;
    private List<Value> arguments;
    private Value returnValue;
    private boolean valuesCleared;

    protected Call(CodeLocation caller, Value instance, List<Value> arguments, Value returnValue, int throwsNullptr, Instruction instruction, boolean controlFlowDependent, boolean runtimeTypeDependent) {
        this.caller = caller;
        this.instance = instance;
        this.arguments = arguments;
        this.returnValue = returnValue;
        this.throwsNullptr = throwsNullptr;
        this.instruction = instruction;
        this.controlFlowDependent = controlFlowDependent;
        this.runtimeTypeDependent = runtimeTypeDependent;
    }

    public boolean isStatic() {
        return InstructionUtil.isStaticCall(this.instruction.opcode);
    }

    public abstract MethodSignature getTarget();

    public abstract boolean hasIncompleteTarget();

    public int getArgumentCount() {
        if (!this.valuesCleared) {
            return this.arguments.size();
        }
        return ClassUtil.internalMethodParameterCount(this.getTarget().descriptor.toString());
    }

    public int getJvmArgumentSize() {
        return ClassUtil.internalMethodParameterSize(this.getTarget().descriptor.toString(), this.isStatic());
    }

    public Value getArgument(int index) {
        if (this.valuesCleared) {
            log.error("Argument requested after values have been cleared!");
            return null;
        }
        if (this.arguments.size() <= index) {
            return null;
        }
        return this.arguments.get(index);
    }

    public void setArguments(List<Value> arguments) {
        this.arguments = arguments;
    }

    public Value getInstance() {
        if (this.valuesCleared) {
            log.error("Instance requested after values have been cleared!");
            return null;
        }
        return this.instance;
    }

    public void setInstance(Value instance) {
        this.instance = instance;
    }

    public Value getReturnValue() {
        if (this.valuesCleared) {
            log.error("Return value requested after values have been cleared!");
            return null;
        }
        return this.returnValue;
    }

    public void setReturnValue(Value returnValue) {
        this.returnValue = returnValue;
    }

    public void clearValues() {
        this.arguments = Collections.nCopies(this.arguments.size(), null);
        this.returnValue = null;
        this.instance = null;
        this.valuesCleared = true;
    }

    public boolean isCertainlyCalled() {
        return !this.controlFlowDependent && !this.runtimeTypeDependent;
    }

    public String toString() {
        String nullSuffix = "";
        if (this.throwsNullptr == 1) {
            nullSuffix = " (always throws NullPointerException)";
        } else if (this.throwsNullptr == 0) {
            nullSuffix = " (might throw NullPointerException)";
        }
        return "[" + this.instruction.getName() + "] " + this.caller + " -> " + this.getTarget() + nullSuffix;
    }

    public String toSimpleString() {
        return "[" + this.instruction.getName() + "] " + this.getTarget();
    }

    public void targetMethodAccept(MemberVisitor memberVisitor) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Call that = (Call)o;
        return this.throwsNullptr == that.throwsNullptr && Objects.equals(this.caller, that.caller) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.instruction, that.instruction);
    }

    public int hashCode() {
        return Objects.hash(this.caller, this.throwsNullptr);
    }
}

