/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.threadsafety.AnnotationInfo;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface ThreadSafetyKnownTypes {
    public ImmutableMap<String, AnnotationInfo> getKnownSafeClasses();

    public ImmutableSet<String> getKnownUnsafeClasses();

    public static final class MapBuilder {
        final ImmutableMap.Builder<String, AnnotationInfo> mapBuilder = ImmutableMap.builder();

        @CanIgnoreReturnValue
        public MapBuilder addClasses(Set<Class<?>> clazzs) {
            MapBuilder mapBuilder = this;
            clazzs.forEach(x$0 -> mapBuilder.add((Class<?>)x$0, new String[0]));
            return this;
        }

        @CanIgnoreReturnValue
        public MapBuilder addStrings(List<String> classNames) {
            MapBuilder mapBuilder = this;
            classNames.forEach(x$0 -> mapBuilder.add((String)x$0, new String[0]));
            return this;
        }

        @CanIgnoreReturnValue
        public MapBuilder addAll(ImmutableMap<String, AnnotationInfo> map) {
            this.mapBuilder.putAll(map);
            return this;
        }

        @CanIgnoreReturnValue
        public MapBuilder add(Class<?> clazz, String ... containerOf) {
            ImmutableSet containerTyParams = ImmutableSet.copyOf((Object[])containerOf);
            HashSet<String> actualTyParams = new HashSet<String>();
            for (TypeVariable<Class<?>> x : clazz.getTypeParameters()) {
                actualTyParams.add(x.getName());
            }
            Sets.SetView difference = Sets.difference((Set)containerTyParams, actualTyParams);
            if (!difference.isEmpty()) {
                throw new AssertionError((Object)String.format("For %s, please update the type parameter(s) from %s to %s", clazz, difference, actualTyParams));
            }
            this.mapBuilder.put((Object)clazz.getName(), (Object)AnnotationInfo.create(clazz.getName(), (Iterable<String>)ImmutableList.copyOf((Object[])containerOf)));
            return this;
        }

        @CanIgnoreReturnValue
        public MapBuilder add(String className, String ... containerOf) {
            this.mapBuilder.put((Object)className, (Object)AnnotationInfo.create(className, (Iterable<String>)ImmutableList.copyOf((Object[])containerOf)));
            return this;
        }

        public ImmutableMap<String, AnnotationInfo> build() {
            return this.mapBuilder.buildKeepingLast();
        }
    }
}

