/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.flogger;

import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import javax.lang.model.type.TypeKind;

final class FloggerHelpers {
    private static final char STRING_FORMAT = 's';

    static char inferFormatSpecifier(Tree piece, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)piece);
        return FloggerHelpers.inferFormatSpecifier(type, state);
    }

    static char inferFormatSpecifier(Type type, VisitorState state) {
        if (type == null) {
            return 's';
        }
        return switch (state.getTypes().unboxedTypeOrType(type).getKind()) {
            case TypeKind.INT, TypeKind.LONG -> 'd';
            case TypeKind.FLOAT, TypeKind.DOUBLE -> 'g';
            case TypeKind.BOOLEAN -> 's';
            default -> 's';
        };
    }

    private FloggerHelpers() {
    }
}

