/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import blogspot.software_and_algorithms.stern_library.optimization.HungarianAlgorithm;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Changes;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Parameter;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ParameterPair;
import java.util.stream.Stream;

final class Costs {
    private final ImmutableList<Parameter> formals;
    private final ImmutableList<Parameter> actuals;
    private final double[][] costMatrix;

    Costs(ImmutableList<Parameter> formals, ImmutableList<Parameter> actuals) {
        this.formals = formals;
        this.actuals = actuals;
        this.costMatrix = new double[formals.size()][actuals.size()];
    }

    Changes computeAssignments() {
        int[] assignments = new HungarianAlgorithm(this.costMatrix).execute();
        ImmutableList formalsWithChange = (ImmutableList)this.formals.stream().filter(f -> assignments[f.index()] != f.index()).collect(ImmutableList.toImmutableList());
        if (formalsWithChange.isEmpty()) {
            return Changes.empty();
        }
        ImmutableList originalCost = (ImmutableList)formalsWithChange.stream().map(f2 -> this.costMatrix[f2.index()][f2.index()]).collect(ImmutableList.toImmutableList());
        ImmutableList assignmentCost = (ImmutableList)formalsWithChange.stream().map(f1 -> this.costMatrix[f1.index()][assignments[f1.index()]]).collect(ImmutableList.toImmutableList());
        ImmutableList changes = (ImmutableList)formalsWithChange.stream().map(f -> ParameterPair.create(f, (Parameter)this.actuals.get(assignments[f.index()]))).collect(ImmutableList.toImmutableList());
        return Changes.create((ImmutableList<Double>)originalCost, (ImmutableList<Double>)assignmentCost, (ImmutableList<ParameterPair>)changes);
    }

    Stream<ParameterPair> viablePairs() {
        return this.formals.stream().flatMap(f -> this.actuals.stream().map(a -> ParameterPair.create(f, a))).filter(p -> this.costMatrix[p.formal().index()][p.actual().index()] != Double.POSITIVE_INFINITY);
    }

    void updatePair(ParameterPair p, double cost) {
        this.costMatrix[p.formal().index()][p.actual().index()] = cost;
    }

    void invalidatePair(ParameterPair p) {
        this.updatePair(p, Double.POSITIVE_INFINITY);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Costs:\n");
        builder.append("formals=").append(this.formals).append("\n");
        builder.append("actuals=").append(this.actuals).append("\n");
        builder.append("costMatrix=\n");
        builder.append(String.format("%20s", ""));
        for (int j = 0; j < this.costMatrix[0].length; ++j) {
            builder.append(String.format("%20s", ((Parameter)this.actuals.get(j)).name()));
        }
        builder.append("\n");
        for (int i = 0; i < this.costMatrix.length; ++i) {
            builder.append(String.format("%20s", ((Parameter)this.formals.get(i)).name()));
            for (int j = 0; j < this.costMatrix[i].length; ++j) {
                builder.append(String.format("%20.1f", this.costMatrix[i][j]));
            }
            builder.append("\n");
        }
        return builder.toString();
    }
}

