/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.android;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;

@BugPattern(tags={"FragileCode"}, summary="On Android versions < P, a wakelock acquired with a timeout may be released by the system before calling `release`, even after checking `isHeld()`. If so, it will throw a RuntimeException. Please wrap in a try/catch block.", severity=BugPattern.SeverityLevel.WARNING)
public class WakelockReleasedDangerously
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String WAKELOCK_CLASS_NAME = "android.os.PowerManager.WakeLock";
    private static final Matcher<ExpressionTree> RELEASE = MethodMatchers.instanceMethod().onExactClass("android.os.PowerManager.WakeLock").named("release");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!state.isAndroidCompatible()) {
            return Description.NO_MATCH;
        }
        if (!RELEASE.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        TryTree enclosingTry = (TryTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), TryTree.class);
        if (enclosingTry != null && this.tryCatchesException(enclosingTry, state.getSymtab().runtimeExceptionType, state)) {
            return Description.NO_MATCH;
        }
        Symbol wakelockSymbol = ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)tree));
        if (wakelockSymbol == null || !this.wakelockMayThrow(wakelockSymbol, state)) {
            return Description.NO_MATCH;
        }
        Tree releaseStatement = state.getPath().getParentPath().getLeaf();
        return this.describeMatch(releaseStatement, (Fix)WakelockReleasedDangerously.getFix(releaseStatement, wakelockSymbol, state));
    }

    private static SuggestedFix getFix(Tree releaseStatement, Symbol wakelockSymbol, VisitorState state) {
        IfTree enclosingIfHeld;
        LambdaExpressionTree enclosingLambda;
        Object before = "\ntry {\n";
        Object after = "\n} catch (RuntimeException unused) {\n// Ignore: already released by timeout.\n// TODO: Log this exception.\n}\n";
        if (releaseStatement instanceof LambdaExpressionTree && (enclosingLambda = (LambdaExpressionTree)releaseStatement).getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
            releaseStatement = enclosingLambda.getBody();
            before = "{" + (String)before;
            after = ";" + (String)after + "}";
        }
        if ((enclosingIfHeld = (IfTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), IfTree.class)) != null) {
            ExpressionTree condition = ASTHelpers.stripParentheses((ExpressionTree)enclosingIfHeld.getCondition());
            if (enclosingIfHeld.getElseStatement() == null && Matchers.instanceMethod().onExactClass(WAKELOCK_CLASS_NAME).named("isHeld").matches((Tree)condition, state) && wakelockSymbol.equals(ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)condition)))) {
                String ifBody = state.getSourceForNode((Tree)enclosingIfHeld.getThenStatement()).trim();
                ifBody = ifBody.startsWith("{") ? ifBody.substring(1) : ifBody;
                ifBody = ifBody.endsWith("}") ? ifBody.substring(0, ifBody.length() - 1) : ifBody;
                ifBody = ifBody.trim();
                String releaseStatementSource = state.getSourceForNode(releaseStatement);
                return SuggestedFix.replace((Tree)enclosingIfHeld, (String)ifBody.replace(releaseStatementSource, (String)before + releaseStatementSource + (String)after));
            }
        }
        return SuggestedFix.builder().prefixWith(releaseStatement, (String)before).postfixWith(releaseStatement, (String)after).build();
    }

    private boolean tryCatchesException(TryTree tryTree, Type exceptionToCatch, VisitorState state) {
        Types types = state.getTypes();
        return tryTree.getCatches().stream().anyMatch(catchClause -> {
            Type catchesException = ASTHelpers.getType((Tree)catchClause.getParameter().getType());
            if (catchesException != null && catchesException.isUnion()) {
                return Streams.stream(((Type.UnionClassType)catchesException).getAlternativeTypes()).anyMatch(caught -> types.isSuperType((Type)caught, exceptionToCatch));
            }
            return types.isSuperType(catchesException, exceptionToCatch);
        });
    }

    private boolean wakelockMayThrow(Symbol wakelockSymbol, VisitorState state) {
        ClassTree enclosingClass = WakelockReleasedDangerously.getTopLevelClass(state);
        ImmutableMultimap<String, MethodInvocationTree> map = this.methodCallsForSymbol(wakelockSymbol, enclosingClass);
        return map.get((Object)"acquire").stream().anyMatch(m -> m.getArguments().size() == 1) && map.get((Object)"setReferenceCounted").stream().noneMatch(m -> Boolean.FALSE.equals(ASTHelpers.constValue((Tree)m.getArguments().get(0), Boolean.class)));
    }

    private static ClassTree getTopLevelClass(VisitorState state) {
        return (ClassTree)Streams.findLast(Streams.stream(state.getPath().iterator()).filter(t -> t.getKind() == Tree.Kind.CLASS)).orElseThrow(() -> new IllegalArgumentException("No enclosing class found"));
    }

    private ImmutableMultimap<String, MethodInvocationTree> methodCallsForSymbol(final Symbol sym, ClassTree classTree) {
        final ImmutableMultimap.Builder methodMap = ImmutableMultimap.builder();
        classTree.accept(new TreeScanner<Void, Void>(this){
            final /* synthetic */ WakelockReleasedDangerously this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree callTree, Void unused) {
                if (sym.equals(ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)callTree)))) {
                    Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)callTree);
                    methodMap.put((Object)((Name)methodSymbol.getSimpleName()).toString(), (Object)callTree);
                }
                return (Void)super.visitMethodInvocation(callTree, null);
            }
        }, null);
        return methodMap.build();
    }
}

