/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import javax.inject.Inject;

public final class WellKnownKeep {
    private static final ImmutableSet<String> EXEMPTING_VARIABLE_ANNOTATIONS = ImmutableSet.of((Object)"jakarta.persistence.Basic", (Object)"jakarta.persistence.Column", (Object)"jakarta.persistence.Id", (Object)"jakarta.persistence.Version", (Object)"jakarta.xml.bind.annotation.XmlElement", (Object)"javax.persistence.Basic", (Object[])new String[]{"javax.persistence.Column", "javax.persistence.Id", "javax.persistence.Version", "javax.xml.bind.annotation.XmlElement", "net.starlark.java.annot.StarlarkBuiltin", "org.junit.Rule", "org.junit.jupiter.api.extension.RegisterExtension", "org.openqa.selenium.support.FindAll", "org.openqa.selenium.support.FindBy", "org.openqa.selenium.support.FindBys", "org.apache.beam.sdk.transforms.DoFn.TimerId", "org.apache.beam.sdk.transforms.DoFn.StateId", "org.springframework.boot.test.mock.mockito.MockBean"});
    private static final ImmutableSet<String> EXEMPTING_METHOD_ANNOTATIONS = ImmutableSet.of((Object)"android.webkit.JavascriptInterface", (Object)"com.fasterxml.jackson.annotation.JsonCreator", (Object)"com.fasterxml.jackson.annotation.JsonProperty", (Object)"com.fasterxml.jackson.annotation.JsonSetter", (Object)"com.fasterxml.jackson.annotation.JsonValue", (Object)"com.google.acai.AfterTest", (Object[])new String[]{"com.google.acai.BeforeSuite", "com.google.acai.BeforeTest", "com.google.caliper.Benchmark", "com.google.common.eventbus.Subscribe", "com.google.inject.Provides", "com.google.inject.Inject", "com.google.inject.multibindings.ProvidesIntoMap", "com.google.inject.multibindings.ProvidesIntoSet", "com.google.inject.throwingproviders.CheckedProvides", "com.tngtech.java.junit.dataprovider.DataProvider", "jakarta.annotation.PreDestroy", "jakarta.annotation.PostConstruct", "jakarta.inject.Inject", "jakarta.persistence.PostLoad", "jakarta.persistence.PostPersist", "jakarta.persistence.PostRemove", "jakarta.persistence.PostUpdate", "jakarta.persistence.PrePersist", "jakarta.persistence.PreRemove", "jakarta.persistence.PreUpdate", "jakarta.validation.constraints.AssertFalse", "jakarta.validation.constraints.AssertTrue", "javax.annotation.PreDestroy", "javax.annotation.PostConstruct", "javax.inject.Inject", "javax.persistence.PostLoad", "javax.persistence.PostPersist", "javax.persistence.PostRemove", "javax.persistence.PostUpdate", "javax.persistence.PrePersist", "javax.persistence.PreRemove", "javax.persistence.PreUpdate", "javax.validation.constraints.AssertFalse", "javax.validation.constraints.AssertTrue", "net.bytebuddy.asm.Advice.OnMethodEnter", "net.bytebuddy.asm.Advice.OnMethodExit", "org.apache.beam.sdk.transforms.DoFn.FinishBundle", "org.apache.beam.sdk.transforms.DoFn.ProcessElement", "org.apache.beam.sdk.transforms.DoFn.StartBundle", "org.aspectj.lang.annotation.Pointcut", "org.aspectj.lang.annotation.After", "org.aspectj.lang.annotation.Before", "org.springframework.context.annotation.Bean", "org.testng.annotations.AfterClass", "org.testng.annotations.AfterMethod", "org.testng.annotations.BeforeClass", "org.testng.annotations.BeforeMethod", "org.testng.annotations.DataProvider", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll", "org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.api.Test", "org.junit.jupiter.params.ParameterizedTest"});
    private static final ImmutableSet<String> EXEMPTING_CLASS_ANNOTATIONS = ImmutableSet.of((Object)"org.junit.jupiter.api.Nested");
    private final ImmutableSet<String> exemptingMethodAnnotations;

    @Inject
    WellKnownKeep(ErrorProneFlags flags) {
        this.exemptingMethodAnnotations = ImmutableSet.builder().addAll(EXEMPTING_METHOD_ANNOTATIONS).addAll((Iterable)flags.getSetOrEmpty("UnusedMethod:ExemptingMethodAnnotations")).build();
    }

    public final boolean shouldKeep(VariableTree tree) {
        return this.shouldKeep(tree, tree.getModifiers(), EXEMPTING_VARIABLE_ANNOTATIONS);
    }

    public final boolean shouldKeep(MethodTree tree) {
        return this.shouldKeep(tree, tree.getModifiers(), this.exemptingMethodAnnotations);
    }

    public final boolean shouldKeep(ClassTree tree) {
        return this.shouldKeep(tree, tree.getModifiers(), EXEMPTING_CLASS_ANNOTATIONS);
    }

    public final boolean shouldKeep(Tree tree) {
        return (Boolean)MoreObjects.firstNonNull((Object)((Boolean)new SimpleTreeVisitor<Boolean, Void>(){

            @Override
            public Boolean visitVariable(VariableTree tree, Void unused) {
                return WellKnownKeep.this.shouldKeep(tree);
            }

            @Override
            public Boolean visitMethod(MethodTree tree, Void unused) {
                return WellKnownKeep.this.shouldKeep(tree);
            }

            @Override
            public Boolean visitClass(ClassTree tree, Void unused) {
                return WellKnownKeep.this.shouldKeep(tree);
            }
        }.visit(tree, null)), (Object)false);
    }

    private final boolean shouldKeep(Tree tree, ModifiersTree modifiers, ImmutableSet<String> exemptingAnnotations) {
        if (ASTHelpers.shouldKeep((Tree)tree)) {
            return true;
        }
        return WellKnownKeep.exemptedByAnnotation(modifiers.getAnnotations(), exemptingAnnotations);
    }

    private static boolean exemptedByAnnotation(List<? extends AnnotationTree> annotations, ImmutableSet<String> exemptingAnnotations) {
        for (AnnotationTree annotationTree : annotations) {
            Symbol.TypeSymbol tsym;
            Type annotationType = ASTHelpers.getType((Tree)annotationTree);
            if (annotationType == null || !exemptingAnnotations.contains((Object)(tsym = annotationType.tsym).getQualifiedName().toString())) continue;
            return true;
        }
        return false;
    }
}

