/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This TestRule isn't annotated with @Rule, so won't be run.")
public final class RuleNotRun
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final ImmutableSet<String> STOP_ANNOTATIONS = ImmutableSet.of((Object)"ClassRule", (Object)"Inject", (Object)"Rule", (Object)"TightRule");
    private static final Supplier<Type> TEST_RULE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("org.junit.rules.TestRule"));

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        final HashMap<Symbol.VarSymbol, Tree> rules = new HashMap<Symbol.VarSymbol, Tree>((Map<Symbol.VarSymbol, Tree>)this.findRules(state));
        if (rules.isEmpty()) {
            return Description.NO_MATCH;
        }
        new TreePathScanner<Void, Void>(this){
            final /* synthetic */ RuleNotRun this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelect, Void unused) {
                this.handle(memberSelect);
                return (Void)super.visitMemberSelect(memberSelect, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifier, Void unused) {
                this.handle(identifier);
                return (Void)super.visitIdentifier(identifier, null);
            }

            private void handle(Tree tree) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                if (symbol instanceof Symbol.VarSymbol) {
                    Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                    if (!(this.getCurrentPath().getParentPath().getLeaf() instanceof MemberSelectTree)) {
                        rules.remove(varSymbol);
                    }
                }
            }
        }.scan(state.getPath(), (Void)null);
        for (Tree ruleTree : rules.values()) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            String rule = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"org.junit.Rule");
            state.reportMatch(this.describeMatch(ruleTree, (Fix)fix.prefixWith(ruleTree, String.format("@%s ", rule)).build()));
        }
        return Description.NO_MATCH;
    }

    private ImmutableMap<Symbol.VarSymbol, Tree> findRules(VisitorState state) {
        final ImmutableMap.Builder rules = ImmutableMap.builder();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state){
            final /* synthetic */ RuleNotRun this$0;
            {
                this.this$0 = this$0;
                super((BugChecker)this$0, state);
            }

            public Void visitClass(ClassTree tree, Void unused) {
                if (!JUnitMatchers.isJUnit4TestClass.matches((Tree)tree, this.state)) {
                    return null;
                }
                for (Tree tree2 : tree.getMembers()) {
                    if (!(tree2 instanceof VariableTree)) continue;
                    VariableTree vt = (VariableTree)tree2;
                    this.scan(vt, null);
                }
                return null;
            }

            public Void visitVariable(VariableTree tree, Void unused) {
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
                if (ASTHelpers.isSubtype((Type)symbol.type, (Type)((Type)TEST_RULE.get(this.state)), (VisitorState)this.state) && STOP_ANNOTATIONS.stream().noneMatch(anno -> ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol.VarSymbol)symbol, (String)anno)) && !symbol.isPrivate() && !RuleNotRun.ignoreBasedOnInitialiser(tree.getInitializer(), this.state)) {
                    rules.put((Object)symbol, (Object)tree);
                }
                return null;
            }
        }.scan((Tree)state.getPath().getCompilationUnit(), null);
        return rules.buildOrThrow();
    }

    private static boolean ignoreBasedOnInitialiser(Tree tree, VisitorState state) {
        if (tree == null) {
            return false;
        }
        AtomicBoolean matched = new AtomicBoolean();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                return (Void)super.visitMethodInvocation(tree, null);
            }
        }.scan(tree, null);
        return matched.get();
    }
}

