/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.TargetType;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="-0 is the same as 0. For the floating-point negative zero, use -0.0.")
public class AttemptedNegativeZero
extends BugChecker
implements BugChecker.UnaryTreeMatcher {
    public Description matchUnary(UnaryTree tree, VisitorState state) {
        String replacement;
        if (tree.getKind() != Tree.Kind.UNARY_MINUS) {
            return Description.NO_MATCH;
        }
        Object negatedConstValue = ASTHelpers.constValue((Tree)tree.getExpression());
        if (negatedConstValue == null) {
            return Description.NO_MATCH;
        }
        if (!negatedConstValue.equals(0) && !negatedConstValue.equals(0L)) {
            return Description.NO_MATCH;
        }
        switch (TargetType.targetType((VisitorState)state).type().getTag()) {
            case DOUBLE: {
                replacement = "-0.0";
                break;
            }
            case FLOAT: {
                replacement = "-0.0f";
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace((Tree)tree, replacement).build());
    }
}

