/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.util.AutoValue_Commented;
import com.google.errorprone.util.ErrorProneComment;
import com.sun.source.tree.Tree;

@AutoValue
public abstract class Commented<T extends Tree> {
    public abstract T tree();

    public abstract ImmutableList<ErrorProneComment> beforeComments();

    public abstract ImmutableList<ErrorProneComment> afterComments();

    static <T extends Tree> Builder<T> builder() {
        return new AutoValue_Commented.Builder();
    }

    @AutoValue.Builder
    static abstract class Builder<T extends Tree> {
        Builder() {
        }

        abstract Builder<T> setTree(T var1);

        protected abstract ImmutableList.Builder<ErrorProneComment> beforeCommentsBuilder();

        protected abstract ImmutableList.Builder<ErrorProneComment> afterCommentsBuilder();

        @CanIgnoreReturnValue
        Builder<T> addComment(ErrorProneComment comment, int nodePosition, int tokenizingOffset, Position position) {
            ErrorProneComment offsetComment = comment.withOffset(tokenizingOffset);
            if (comment.getSourcePos(0) < nodePosition) {
                if (position.equals((Object)Position.BEFORE) || position.equals((Object)Position.ANY)) {
                    this.beforeCommentsBuilder().add((Object)offsetComment);
                }
            } else if (position.equals((Object)Position.AFTER) || position.equals((Object)Position.ANY)) {
                this.afterCommentsBuilder().add((Object)offsetComment);
            }
            return this;
        }

        @CanIgnoreReturnValue
        Builder<T> addAllComment(Iterable<ErrorProneComment> comments, int nodePosition, int tokenizingOffset, Position position) {
            for (ErrorProneComment comment : comments) {
                this.addComment(comment, nodePosition, tokenizingOffset, position);
            }
            return this;
        }

        abstract Commented<T> build();
    }

    public static enum Position {
        BEFORE,
        AFTER,
        ANY;

    }
}

