/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.WildcardTree;
import java.util.List;
import java.util.Optional;

@BugPattern(summary="Nullness annotations directly on wildcard types are interpreted differently by different tools", severity=BugPattern.SeverityLevel.WARNING)
public class NullableWildcard
extends BugChecker
implements BugChecker.AnnotatedTypeTreeMatcher {
    public Description matchAnnotatedType(AnnotatedTypeTree tree, VisitorState state) {
        Optional nullness = NullnessAnnotations.fromAnnotationTrees(tree.getAnnotations());
        if (nullness.isEmpty()) {
            return Description.NO_MATCH;
        }
        ExpressionTree expressionTree = tree.getUnderlyingType();
        if (!(expressionTree instanceof WildcardTree)) {
            return Description.NO_MATCH;
        }
        WildcardTree wildcardTree = (WildcardTree)((Object)expressionTree);
        return this.describeMatch(tree, this.fix(tree.getAnnotations(), wildcardTree, state));
    }

    Fix fix(List<? extends AnnotationTree> annotations, WildcardTree tree, VisitorState state) {
        ImmutableList existingAnnotations = NullnessAnnotations.annotationsRelevantToNullness(annotations);
        if (existingAnnotations.size() != 1) {
            return SuggestedFix.emptyFix();
        }
        AnnotationTree existingAnnotation = (AnnotationTree)Iterables.getOnlyElement((Iterable)existingAnnotations);
        SuggestedFix.Builder fix = SuggestedFix.builder().delete((Tree)existingAnnotation);
        switch (tree.getKind()) {
            case EXTENDS_WILDCARD: {
                AnnotatedTypeTree annotatedTypeTree;
                Tree bound = tree.getBound();
                if (bound instanceof AnnotatedTypeTree && NullnessAnnotations.fromAnnotationTrees((annotatedTypeTree = (AnnotatedTypeTree)bound).getAnnotations()).isPresent()) {
                    return SuggestedFix.emptyFix();
                }
                return fix.prefixWith(bound, String.format("%s ", state.getSourceForNode((Tree)existingAnnotation))).build();
            }
            case SUPER_WILDCARD: {
                return SuggestedFix.emptyFix();
            }
            case UNBOUNDED_WILDCARD: {
                return fix.postfixWith((Tree)tree, String.format(" extends %s Object", state.getSourceForNode((Tree)existingAnnotation))).build();
            }
        }
        throw new AssertionError((Object)tree.getKind());
    }
}

