/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Name;

@BugPattern(summary="The result of this API is ignorable, so it does not need to be captured / assigned into an `unused` variable.", severity=BugPattern.SeverityLevel.WARNING)
public final class UnnecessarilyUsedValue
extends BugChecker
implements BugChecker.AssignmentTreeMatcher,
BugChecker.VariableTreeMatcher {
    public Description matchAssignment(AssignmentTree assignmentTree, VisitorState state) {
        IdentifierTree identifierTree;
        ExpressionTree expressionTree;
        if (UnnecessarilyUsedValue.isTryResource(assignmentTree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree expressionTree2 = assignmentTree.getExpression();
        if (UnnecessarilyUsedValue.isMethodInvocationLike(expressionTree2) && (expressionTree = assignmentTree.getVariable()) instanceof IdentifierTree && UnnecessarilyUsedValue.isIgnorable(expressionTree2, (identifierTree = (IdentifierTree)expressionTree).getName())) {
            return this.describeMatch(assignmentTree, (Fix)SuggestedFix.replace((Tree)assignmentTree, (String)state.getSourceForNode((Tree)expressionTree2)));
        }
        return Description.NO_MATCH;
    }

    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        if (UnnecessarilyUsedValue.isTryResource(variableTree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree initializer = variableTree.getInitializer();
        if (UnnecessarilyUsedValue.isMethodInvocationLike(initializer) && UnnecessarilyUsedValue.isIgnorable(initializer, variableTree.getName())) {
            return this.describeMatch(variableTree, (Fix)SuggestedFix.replace((Tree)variableTree, (String)(state.getSourceForNode((Tree)initializer) + ";")));
        }
        return Description.NO_MATCH;
    }

    private static boolean isMethodInvocationLike(ExpressionTree initializer) {
        return initializer instanceof MethodInvocationTree || initializer instanceof NewClassTree;
    }

    private static boolean isTryResource(Tree expression, VisitorState state) {
        TryTree tryTree = (TryTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), TryTree.class);
        return tryTree != null && tryTree.getResources().contains(expression);
    }

    private static boolean isIgnorable(ExpressionTree methodInvocationTree, Name name) {
        return ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)ASTHelpers.getSymbol((Tree)methodInvocationTree), (String)"CanIgnoreReturnValue") && name.toString().matches("unused\\d*");
    }
}

