/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Changes;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Heuristic;
import com.google.errorprone.names.NamingConventions;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Collections;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

final class EnclosedByReverseHeuristic
implements Heuristic {
    private static final ImmutableSet<String> DEFAULT_REVERSE_WORDS_TERMS = ImmutableSet.of((Object)"backward", (Object)"backwards", (Object)"complement", (Object)"endian", (Object)"flip", (Object)"inverse", (Object[])new String[]{"invert", "landscape", "opposite", "portrait", "reciprocal", "reverse", "reversed", "rotate", "rotated", "rotation", "swap", "swapped", "transpose", "transposed", "undo"});
    private final ImmutableSet<String> reverseWordsTerms;

    EnclosedByReverseHeuristic() {
        this(DEFAULT_REVERSE_WORDS_TERMS);
    }

    EnclosedByReverseHeuristic(ImmutableSet<String> reverseWordsTerms) {
        this.reverseWordsTerms = reverseWordsTerms;
    }

    @Override
    public boolean isAcceptableChange(Changes changes, Tree node, Symbol.MethodSymbol symbol, VisitorState state) {
        return this.findReverseWordsMatchInParentNodes(state) == null;
    }

    private @Nullable String findReverseWordsMatchInParentNodes(VisitorState state) {
        return Streams.stream((Iterable)state.getPath()).flatMap(t -> EnclosedByReverseHeuristic.getName(t).stream()).filter(n -> !Collections.disjoint(NamingConventions.splitToLowercaseTerms((String)n), this.reverseWordsTerms)).findFirst().orElse(null);
    }

    private static Optional<String> getName(Tree tree) {
        if (tree instanceof MethodTree) {
            MethodTree methodTree = (MethodTree)tree;
            return Optional.of(methodTree.getName().toString());
        }
        if (tree instanceof ClassTree) {
            ClassTree classTree = (ClassTree)tree;
            return Optional.of(classTree.getSimpleName().toString());
        }
        return Optional.empty();
    }
}

