/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Enums;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.AbstractMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

@BugPattern(summary="Prefer instanceof over getKind() checks where possible, as these work well with pattern matching instanceofs", severity=BugPattern.SeverityLevel.WARNING)
public final class PreferInstanceofOverGetKind
extends BugChecker
implements BugChecker.BinaryTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> GET_KIND = Matchers.instanceMethod().onDescendantOf(Tree.class.getName()).named("getKind");
    private static final ImmutableMap<Tree.Kind, Class<?>> KIND_TO_CLASS = (ImmutableMap)Multimaps.asMap((ListMultimap)((ListMultimap)EnumSet.allOf(Tree.Kind.class).stream().filter(k -> k.asInterface() != null).collect(ImmutableListMultimap.toImmutableListMultimap(k -> k.asInterface(), k -> k)))).entrySet().stream().flatMap(e -> ((List)e.getValue()).size() == 1 ? Stream.of(new AbstractMap.SimpleEntry<Tree.Kind, Class>((Tree.Kind)((Object)((Object)Iterables.getOnlyElement((Iterable)((Iterable)e.getValue())))), (Class)e.getKey())) : Stream.empty()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        switch (tree.getKind()) {
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        return this.getDescription(tree, tree.getLeftOperand(), tree.getRightOperand(), tree.getKind() == Tree.Kind.NOT_EQUAL_TO, state);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!Matchers.INSTANCE_EQUALS.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (receiver == null) {
            return Description.NO_MATCH;
        }
        ExpressionTree argument = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        boolean negated = state.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.LOGICAL_COMPLEMENT;
        return this.getDescription(negated ? state.getPath().getParentPath().getLeaf() : tree, receiver, argument, negated, state);
    }

    private Description getDescription(Tree tree, ExpressionTree left, ExpressionTree right, boolean negated, VisitorState state) {
        if (!GET_KIND.matches((Tree)left, state)) {
            return Description.NO_MATCH;
        }
        Symbol rhsSymbol = ASTHelpers.getSymbol((Tree)right);
        if (rhsSymbol == null || !rhsSymbol.owner.equals(state.getSymbolFromString(Tree.Kind.class.getName()))) {
            return Description.NO_MATCH;
        }
        Tree.Kind kind = (Tree.Kind)((Object)Enums.getIfPresent(Tree.Kind.class, (String)rhsSymbol.getSimpleName().toString()).orNull());
        if (kind == null) {
            return Description.NO_MATCH;
        }
        Class treeClass = (Class)KIND_TO_CLASS.get((Object)kind);
        if (treeClass == null) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String name = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)treeClass.getName());
        String replacement = String.format("%s instanceof %s", state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)left)), name);
        return this.describeMatch(tree, (Fix)fix.replace(tree, !negated ? replacement : String.format("!(%s)", replacement)).build());
    }
}

