/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.List;

@BugPattern(summary="Type-use nullability annotations should annotate the inner class, not the outer class (e.g., write `A.@Nullable B` instead of `@Nullable A.B`).", severity=BugPattern.SeverityLevel.ERROR)
public final class NullableOnContainingClass
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final ImmutableSet<String> NULLABLE_ANNOTATION_NAMES = ImmutableSet.of((Object)"Nullable", (Object)"NonNull", (Object)"NullableType");
    private static final ImmutableSet<ElementType> TYPE_USE_OR_TYPE_PARAMETER = ImmutableSet.of((Object)((Object)ElementType.TYPE_USE), (Object)((Object)ElementType.TYPE_PARAMETER));

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        ExpressionTree expressionTree = tree.getExpression();
        if (!(expressionTree instanceof AnnotatedTypeTree)) {
            return Description.NO_MATCH;
        }
        AnnotatedTypeTree annotatedTypeTree = (AnnotatedTypeTree)expressionTree;
        return this.handle(annotatedTypeTree.getAnnotations(), tree, state);
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        return this.handle(tree.getModifiers().getAnnotations(), tree.getReturnType(), state);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        return this.handle(tree.getModifiers().getAnnotations(), tree.getType(), state);
    }

    private Description handle(List<? extends AnnotationTree> annotations, Tree type, VisitorState state) {
        if (!(type instanceof MemberSelectTree)) {
            return Description.NO_MATCH;
        }
        MemberSelectTree memberSelectTree = (MemberSelectTree)type;
        int endOfOuterType = state.getEndPosition((Tree)memberSelectTree.getExpression());
        for (AnnotationTree annotationTree : annotations) {
            if (!NullableOnContainingClass.isOnlyTypeAnnotation(ASTHelpers.getSymbol((Tree)annotationTree)) || !NULLABLE_ANNOTATION_NAMES.contains((Object)((Name)ASTHelpers.getType((Tree)annotationTree).tsym.getSimpleName()).toString()) || state.getEndPosition((Tree)annotationTree) >= endOfOuterType) continue;
            return this.describeMatch(annotationTree, (Fix)SuggestedFix.builder().delete((Tree)annotationTree).replace(endOfOuterType + 1, endOfOuterType + 1, state.getSourceForNode((Tree)annotationTree) + " ").build());
        }
        return Description.NO_MATCH;
    }

    private static boolean isOnlyTypeAnnotation(Symbol anno) {
        Target target = anno.getAnnotation(Target.class);
        ImmutableSet elementTypes = target == null ? ImmutableSet.of() : ImmutableSet.copyOf((Object[])target.value());
        return elementTypes.contains((Object)ElementType.TYPE_USE) && TYPE_USE_OR_TYPE_PARAMETER.containsAll((Collection)elementTypes);
    }
}

