/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.ArrayDeque;

@BugPattern(summary="Certain types should not be passed across API boundaries.", severity=BugPattern.SeverityLevel.WARNING)
public final class NonApiType
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String FLOGGER_LINK = "";
    private static final String TYPE_GENERALITY_LINK = "";
    private static final String INTERFACES_NOT_IMPLS_LINK = "";
    private static final String PRIMITIVE_ARRAYS_LINK = "";
    private static final String PROTO_TIME_SERIALIZATION_LINK = "";
    private static final String ITERATOR_LINK = "";
    private static final String STREAM_LINK = "";
    private static final String OPTIONAL_AS_PARAM_LINK = "";
    private static final String PREFER_JDK_OPTIONAL_LINK = "";
    private static final TypePredicate NON_GRAPH_WRAPPER = TypePredicates.not((TypePredicate)TypePredicates.isDescendantOf((String)"com.google.apps.framework.producers.GraphWrapper"));
    private static final ImmutableSet<TypeToCheck> NON_API_TYPES = ImmutableSet.of((Object)NonApiType.withPublicVisibility(TypePredicates.anyOf((TypePredicate[])new TypePredicate[]{(TypePredicate & Serializable)(t, s) -> ASTHelpers.isSameType((Type)t, (Type)s.getTypes().makeArrayType(s.getSymtab().intType), (VisitorState)s), (TypePredicate & Serializable)(t, s) -> ASTHelpers.isSameType((Type)t, (Type)NonApiType.makeArrayType("java.lang.Integer", s), (VisitorState)s)}), "Prefer an ImmutableIntArray instead. ", ApiElementType.ANY), (Object)NonApiType.withPublicVisibility(TypePredicates.anyOf((TypePredicate[])new TypePredicate[]{(TypePredicate & Serializable)(t, s) -> ASTHelpers.isSameType((Type)t, (Type)s.getTypes().makeArrayType(s.getSymtab().doubleType), (VisitorState)s), (TypePredicate & Serializable)(t, s) -> ASTHelpers.isSameType((Type)t, (Type)NonApiType.makeArrayType("java.lang.Double", s), (VisitorState)s)}), "Prefer an ImmutableDoubleArray instead. ", ApiElementType.ANY), (Object)NonApiType.withPublicVisibility(TypePredicates.anyOf((TypePredicate[])new TypePredicate[]{(TypePredicate & Serializable)(t, s) -> ASTHelpers.isSameType((Type)t, (Type)s.getTypes().makeArrayType(s.getSymtab().longType), (VisitorState)s), (TypePredicate & Serializable)(t, s) -> ASTHelpers.isSameType((Type)t, (Type)NonApiType.makeArrayType("java.lang.Long", s), (VisitorState)s)}), "Prefer an ImmutableLongArray instead. ", ApiElementType.ANY), (Object)NonApiType.withPublicVisibility(TypePredicates.isExactType((String)"java.util.Optional"), NON_GRAPH_WRAPPER, "Avoid Optional parameters. ", ApiElementType.PARAMETER), (Object)NonApiType.withPublicVisibility(TypePredicates.isExactType((String)"com.google.common.base.Optional"), NON_GRAPH_WRAPPER, "Prefer a java.util.Optional instead. ", ApiElementType.ANY), (Object)NonApiType.withPublicVisibility(TypePredicates.isExactType((String)"com.google.common.collect.ImmutableCollection"), NON_GRAPH_WRAPPER, "Consider accepting a java.util.Collection or Iterable instead. ", ApiElementType.PARAMETER), (Object[])new TypeToCheck[]{NonApiType.withPublicVisibility(TypePredicates.isExactType((String)"com.google.common.collect.ImmutableList"), NON_GRAPH_WRAPPER, "Consider accepting a java.util.List or Iterable instead. ", ApiElementType.PARAMETER), NonApiType.withPublicVisibility(TypePredicates.isExactType((String)"com.google.common.collect.ImmutableSet"), NON_GRAPH_WRAPPER, "Consider accepting a java.util.Set or Iterable instead. ", ApiElementType.PARAMETER), NonApiType.withPublicVisibility(TypePredicates.isExactType((String)"com.google.common.collect.ImmutableMap"), NON_GRAPH_WRAPPER, "Consider accepting a java.util.Map instead. ", ApiElementType.PARAMETER), NonApiType.withAnyVisibility(TypePredicates.anyOf((TypePredicate[])new TypePredicate[]{TypePredicates.isExactType((String)"java.util.ArrayList"), TypePredicates.isExactType((String)"java.util.LinkedList")}), "Prefer a java.util.List instead. ", ApiElementType.ANY), NonApiType.withAnyVisibility(TypePredicates.anyOf((TypePredicate[])new TypePredicate[]{TypePredicates.isExactType((String)"java.util.HashSet"), TypePredicates.isExactType((String)"java.util.LinkedHashSet"), TypePredicates.isExactType((String)"java.util.TreeSet")}), "Prefer a java.util.Set instead. ", ApiElementType.ANY), NonApiType.withAnyVisibility(TypePredicates.anyOf((TypePredicate[])new TypePredicate[]{TypePredicates.isExactType((String)"java.util.HashMap"), TypePredicates.isExactType((String)"java.util.LinkedHashMap"), TypePredicates.isExactType((String)"java.util.TreeMap")}), "Prefer a java.util.Map instead. ", ApiElementType.ANY), NonApiType.withPublicVisibility(TypePredicates.isDescendantOf((String)"java.util.Iterator"), "Prefer returning a Stream (or collecting to an ImmutableList/ImmutableSet) instead. ", ApiElementType.RETURN_TYPE), NonApiType.withPublicVisibility(TypePredicates.isDescendantOf((String)"java.util.stream.Stream"), "Prefer accepting an Iterable or Collection instead. ", ApiElementType.PARAMETER), NonApiType.withAnyVisibility(TypePredicates.isExactType((String)"com.google.inject.AbstractModule"), "Prefer using Module instead.", ApiElementType.ANY), NonApiType.withPublicVisibility(TypePredicates.isExactType((String)"com.google.protobuf.Duration"), "Prefer a java.time.Duration instead. ", ApiElementType.ANY), NonApiType.withPublicVisibility(TypePredicates.isExactType((String)"com.google.protobuf.Timestamp"), "Prefer a java.time.Instant instead. ", ApiElementType.ANY), NonApiType.withPublicVisibility(TypePredicates.isExactType((String)"com.google.type.Date"), "Prefer a java.time.LocalDate instead. ", ApiElementType.ANY), NonApiType.withPublicVisibility(TypePredicates.isExactType((String)"com.google.type.DateTime"), "Prefer a java.time.LocalDateTime instead. ", ApiElementType.ANY), NonApiType.withPublicVisibility(TypePredicates.isExactType((String)"com.google.type.DayOfWeek"), "Prefer a java.time.DayOfWeek instead. ", ApiElementType.ANY), NonApiType.withPublicVisibility(TypePredicates.isExactType((String)"com.google.type.Month"), "Prefer a java.time.Month instead. ", ApiElementType.ANY), NonApiType.withPublicVisibility(TypePredicates.isExactType((String)"com.google.type.TimeOfDay"), "Prefer a java.time.LocalTime instead. ", ApiElementType.ANY), NonApiType.withPublicVisibility(TypePredicates.isExactType((String)"com.google.type.TimeZone"), "Prefer a java.time.ZoneId instead. ", ApiElementType.ANY), NonApiType.withAnyVisibility(TypePredicates.anyOf((TypePredicate[])new TypePredicate[]{TypePredicates.isDescendantOf((String)"com.google.protobuf.ProtocolStringList")}), "Unless you need methods declared on the subtypes, prefer a java.util.List<String> instead. ", ApiElementType.ANY), NonApiType.withAnyVisibility(TypePredicates.anyOf((TypePredicate[])new TypePredicate[]{TypePredicates.isDescendantOf((String)"com.google.common.flogger.FluentLogger"), TypePredicates.isDescendantOf((String)"com.google.common.flogger.GoogleLogger"), TypePredicates.isDescendantOf((String)"com.google.common.flogger.android.AndroidFluentLogger")}), "There is no advantage to passing around a logger rather than declaring one in the class that needs it. ", ApiElementType.ANY)});

    private static Type makeArrayType(String typeName, VisitorState state) {
        return state.getTypes().makeArrayType(state.getTypeFromString(typeName));
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (ASTHelpers.isRecord((Symbol)symbol.owner)) {
            return Description.NO_MATCH;
        }
        Type enclosingType = symbol.owner.type;
        boolean isPublicApi = ASTHelpers.methodIsPublicAndNotAnOverride((Symbol.MethodSymbol)symbol, (VisitorState)state) && state.errorProneOptions().isPubliclyVisibleTarget();
        for (Tree tree2 : tree.getParameters()) {
            this.checkType(tree2, ApiElementType.PARAMETER, isPublicApi, enclosingType, state);
        }
        this.checkType(tree.getReturnType(), ApiElementType.RETURN_TYPE, isPublicApi, enclosingType, state);
        return Description.NO_MATCH;
    }

    private void checkType(Tree tree, ApiElementType elementType, boolean isPublicApi, Type enclosingType, VisitorState state) {
        if (this.isSuppressed(tree, state)) {
            return;
        }
        Type type = ASTHelpers.getType((Tree)tree);
        if (type == null) {
            return;
        }
        for (TypeToCheck typeToCheck : NON_API_TYPES) {
            if (!typeToCheck.matches(type, enclosingType, state) || typeToCheck.elementType() != ApiElementType.ANY && typeToCheck.elementType() != elementType || !isPublicApi && typeToCheck.visibility() != ApiVisibility.ANY) continue;
            state.reportMatch(this.buildDescription(tree).setMessage(typeToCheck.failureMessage()).build());
        }
    }

    private static TypeToCheck withPublicVisibility(TypePredicate typePredicate, String failureMessage, ApiElementType elementType) {
        return NonApiType.withPublicVisibility(typePredicate, TypePredicates.anything(), failureMessage, elementType);
    }

    private static TypeToCheck withPublicVisibility(TypePredicate typePredicate, TypePredicate enclosingTypePredicate, String failureMessage, ApiElementType elementType) {
        return new TypeToCheck(typePredicate, enclosingTypePredicate, failureMessage, ApiVisibility.PUBLIC, elementType);
    }

    private static TypeToCheck withAnyVisibility(TypePredicate typePredicate, String failureMessage, ApiElementType elementType) {
        return new TypeToCheck(typePredicate, TypePredicates.anything(), failureMessage, ApiVisibility.ANY, elementType);
    }

    static enum ApiElementType {
        PARAMETER,
        RETURN_TYPE,
        ANY;

    }

    private record TypeToCheck(TypePredicate typePredicate, TypePredicate enclosingTypePredicate, String failureMessage, ApiVisibility visibility, ApiElementType elementType) {
        final boolean matches(Type type, Type enclosingType, VisitorState state) {
            if (this.enclosingTypePredicate().apply(enclosingType, state)) {
                ArrayDeque<Type> types = new ArrayDeque<Type>();
                types.add(type);
                while (!types.isEmpty()) {
                    Type head = (Type)types.poll();
                    if (this.typePredicate().apply(head, state)) {
                        return true;
                    }
                    types.addAll(head.getTypeArguments());
                }
            }
            return false;
        }
    }

    static enum ApiVisibility {
        PUBLIC,
        ANY;

    }
}

