/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;

@BugPattern(summary="When only using JUnit Assert's static methods, you should import statically instead of extending.", severity=BugPattern.SeverityLevel.WARNING)
public class ExtendingJUnitAssert
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ExpressionTree> STATIC_ASSERT = Matchers.staticMethod().onClass("org.junit.Assert").withAnyName();
    private static final Supplier<Type> ORG_JUNIT_ASSERT = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("org.junit.Assert"));

    public Description matchClass(ClassTree tree, VisitorState state) {
        Tree extendsClause = tree.getExtendsClause();
        Type type = ASTHelpers.getType((Tree)extendsClause);
        if (ASTHelpers.isSameType((Type)type, (Type)((Type)ORG_JUNIT_ASSERT.get(state)), (VisitorState)state)) {
            return this.describeMatch(extendsClause, (Fix)this.fixAsserts(tree, state));
        }
        return Description.NO_MATCH;
    }

    private SuggestedFix fixAsserts(ClassTree tree, final VisitorState state) {
        ErrorProneToken token;
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        tree.accept(new TreeScanner<Void, Void>(this){
            final /* synthetic */ ExtendingJUnitAssert this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                if (STATIC_ASSERT.matches((Tree)tree, state)) {
                    String assertType = ((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).toString();
                    fix.addStaticImport("org.junit.Assert." + assertType);
                }
                return (Void)super.visitMethodInvocation(tree, null);
            }
        }, null);
        Tree extendsClause = tree.getExtendsClause();
        int endOfExtendsClause = state.getEndPosition(extendsClause);
        ImmutableList tokens = state.getOffsetTokensForNode((Tree)tree);
        int startPos = 0;
        UnmodifiableIterator unmodifiableIterator = tokens.iterator();
        while (unmodifiableIterator.hasNext() && (token = (ErrorProneToken)unmodifiableIterator.next()).pos() <= endOfExtendsClause) {
            int curr;
            if (token.kind() != Tokens.TokenKind.EXTENDS || (curr = token.pos()) <= startPos) continue;
            startPos = curr;
        }
        return fix.replace(startPos, endOfExtendsClause, "").build();
    }
}

