/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;

@BugPattern(summary="Fields with CONSTANT_CASE names should be both static and final", severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"})
public class ConstantField
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        if (sym.getKind() != ElementKind.FIELD) {
            return Description.NO_MATCH;
        }
        String name = ((Name)sym.getSimpleName()).toString();
        if (sym.isStatic() && sym.getModifiers().contains((Object)Modifier.FINAL)) {
            return Description.NO_MATCH;
        }
        if (!name.equals(Ascii.toUpperCase((String)name))) {
            return Description.NO_MATCH;
        }
        Description.Builder descriptionBuilder = this.buildDescription(tree);
        if (ConstantField.canBecomeStaticMember(sym)) {
            SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.STATIC}).map(f -> SuggestedFix.builder().setShortDescription("make static and final").merge(f).build()).ifPresent(arg_0 -> ((Description.Builder)descriptionBuilder).addFix(arg_0));
        }
        return descriptionBuilder.addFix((Fix)SuggestedFix.builder().setShortDescription("change to camelcase").merge(SuggestedFixes.renameVariable((VariableTree)tree, (String)CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name), (VisitorState)state)).build()).build();
    }

    private static boolean canBecomeStaticMember(Symbol.VarSymbol sym) {
        Symbol.ClassSymbol owningClass = sym.enclClass();
        return switch (owningClass.getNestingKind()) {
            case NestingKind.LOCAL, NestingKind.ANONYMOUS -> false;
            default -> !owningClass.isInner();
        };
    }
}

