/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.FieldMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;

@BugPattern(summary="Don't use try-with-resources to manage standard output streams, closing the stream will cause subsequent output to standard output or standard error to be lost", severity=BugPattern.SeverityLevel.WARNING)
public class ClosingStandardOutputStreams
extends BugChecker
implements BugChecker.TryTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{FieldMatchers.staticField((String)"java.lang.System", (String)"err"), FieldMatchers.staticField((String)"java.lang.System", (String)"out")});

    public Description matchTry(TryTree tree, VisitorState state) {
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(state){

            public Void visitTry(TryTree tree, Void unused) {
                tree.getResources().forEach(r -> r.accept(this, null));
                return null;
            }

            public Void visitMemberSelect(MemberSelectTree tree, Void unused) {
                if (MATCHER.matches((Tree)tree, this.state)) {
                    this.state.reportMatch(ClosingStandardOutputStreams.this.describeMatch(tree));
                }
                return null;
            }
        }.scan(state.getPath(), null);
        return Description.NO_MATCH;
    }
}

