/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.CanBeStaticAnalyzer;
import com.google.errorprone.bugpatterns.WellKnownKeep;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.SourceVersion;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;

@BugPattern(summary="Inner class is non-static but does not reference enclosing class", severity=BugPattern.SeverityLevel.WARNING, tags={"Style", "Performance"})
public class ClassCanBeStatic
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String REFASTER_ANNOTATION = "com.google.errorprone.refaster.annotation.BeforeTemplate";
    private final WellKnownKeep wellKnownKeep;

    @Inject
    ClassCanBeStatic(WellKnownKeep wellKnownKeep) {
        this.wellKnownKeep = wellKnownKeep;
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol currentClass = ASTHelpers.getSymbol((ClassTree)tree);
        if (!currentClass.hasOuterInstance()) {
            return Description.NO_MATCH;
        }
        if (currentClass.getNestingKind() != NestingKind.MEMBER) {
            return Description.NO_MATCH;
        }
        switch (ASTHelpers.enclosingClass((Symbol)currentClass).getNestingKind()) {
            case TOP_LEVEL: {
                break;
            }
            case MEMBER: {
                if (SourceVersion.supportsStaticInnerClass((Context)state.context) || !ASTHelpers.enclosingClass((Symbol)currentClass).hasOuterInstance()) break;
                return Description.NO_MATCH;
            }
            case LOCAL: {
                if (SourceVersion.supportsStaticInnerClass((Context)state.context)) break;
                return Description.NO_MATCH;
            }
            case ANONYMOUS: {
                return Description.NO_MATCH;
            }
        }
        if (tree.getExtendsClause() != null && ASTHelpers.getType((Tree)tree.getExtendsClause()).tsym.hasOuterInstance()) {
            return Description.NO_MATCH;
        }
        if (CanBeStaticAnalyzer.referencesOuter(tree, currentClass, state)) {
            return Description.NO_MATCH;
        }
        if (this.wellKnownKeep.shouldKeep(tree)) {
            return Description.NO_MATCH;
        }
        if (tree.getMembers().stream().anyMatch(m -> ASTHelpers.hasAnnotation((Tree)m, (String)REFASTER_ANNOTATION, (VisitorState)state))) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC}).orElse(SuggestedFix.emptyFix()));
    }
}

