/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.RenamedDataEntry;
import proguard.util.StringFunction;

public class RenamedDataEntryWriter
implements DataEntryWriter {
    private final StringFunction nameFunction;
    private final DataEntryWriter dataEntryWriter;

    public RenamedDataEntryWriter(StringFunction nameFunction, DataEntryWriter dataEntryWriter) {
        this.nameFunction = nameFunction;
        this.dataEntryWriter = dataEntryWriter;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        boolean result;
        String name = dataEntry.getName() + '/';
        String newName = this.nameFunction.transform(name);
        boolean bl = result = newName != null && newName.length() > 0;
        if (result) {
            this.dataEntryWriter.createDirectory(new RenamedDataEntry(dataEntry, newName.substring(0, newName.length() - 1)));
        }
        return result;
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        DataEntry renamedDataEntry1 = this.rename(dataEntry1);
        DataEntry renamedDataEntry2 = this.rename(dataEntry2);
        return renamedDataEntry1 != null && renamedDataEntry2 != null && this.dataEntryWriter.sameOutputStream(renamedDataEntry1, renamedDataEntry2);
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        DataEntry renamedDataEntry = this.rename(dataEntry);
        return renamedDataEntry == null ? null : this.dataEntryWriter.createOutputStream(renamedDataEntry);
    }

    @Override
    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    @Override
    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "RenamedDataEntryWriter");
        this.dataEntryWriter.println(pw, prefix);
    }

    private DataEntry rename(DataEntry dataEntry) {
        String name = dataEntry.getName();
        String newName = this.nameFunction.transform(name);
        return newName == null ? null : new RenamedDataEntry(dataEntry, newName);
    }
}

