/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.model;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.turbine.escape.SourceCodeEscapers;
import com.google.turbine.model.TurbineConstantTypeKind;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import org.jspecify.annotations.Nullable;

public abstract class Const {
    public abstract int hashCode();

    public abstract boolean equals(@Nullable Object var1);

    public abstract String toString();

    public abstract Kind kind();

    public static class ArrayInitValue
    extends Const {
        private final ImmutableList<Const> elements;

        public ArrayInitValue(ImmutableList<Const> elements) {
            this.elements = elements;
        }

        @Override
        public Kind kind() {
            return Kind.ARRAY;
        }

        public ImmutableList<Const> elements() {
            return this.elements;
        }

        @Override
        public int hashCode() {
            return this.elements.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return obj instanceof ArrayInitValue && this.elements.equals(((ArrayInitValue)obj).elements);
        }

        @Override
        public String toString() {
            return "{" + Joiner.on((String)", ").join(this.elements) + "}";
        }
    }

    public static class ByteValue
    extends Value {
        private final byte value;

        public ByteValue(byte value) {
            this.value = value;
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.BYTE;
        }

        public byte value() {
            return this.value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return Byte.hashCode(this.value);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return obj instanceof ByteValue && this.value == ((ByteValue)obj).value;
        }

        @Override
        public String toString() {
            return String.format("(byte)0x%02x", this.value);
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitByte(this.value, p);
        }
    }

    public static class ShortValue
    extends Value {
        private final short value;

        public ShortValue(short value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitShort(this.value, p);
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.SHORT;
        }

        public short value() {
            return this.value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return Short.hashCode(this.value);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return obj instanceof ShortValue && this.value == ((ShortValue)obj).value;
        }
    }

    public static class StringValue
    extends Value {
        private final String value;

        public StringValue(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return "\"" + SourceCodeEscapers.javaCharEscaper().escape(this.value) + "\"";
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitString(this.value, p);
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.STRING;
        }

        public String value() {
            return this.value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return obj instanceof StringValue && this.value.equals(((StringValue)obj).value);
        }
    }

    public static class DoubleValue
    extends Value {
        private final double value;

        public DoubleValue(double value) {
            this.value = value;
        }

        @Override
        public String toString() {
            if (Double.isNaN(this.value)) {
                return "0.0/0.0";
            }
            if (this.value == Double.POSITIVE_INFINITY) {
                return "1.0/0.0";
            }
            if (this.value == Double.NEGATIVE_INFINITY) {
                return "-1.0/0.0";
            }
            return String.valueOf(this.value);
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitDouble(this.value, p);
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.DOUBLE;
        }

        public double value() {
            return this.value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return Double.hashCode(this.value);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return obj instanceof DoubleValue && this.value == ((DoubleValue)obj).value;
        }
    }

    public static class FloatValue
    extends Value {
        private final float value;

        public FloatValue(float value) {
            this.value = value;
        }

        @Override
        public String toString() {
            if (Float.isNaN(this.value)) {
                return "0.0f/0.0f";
            }
            return this.value + "f";
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitFloat(this.value, p);
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.FLOAT;
        }

        public float value() {
            return this.value;
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public int hashCode() {
            return Float.hashCode(this.value);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return obj instanceof FloatValue && this.value == ((FloatValue)obj).value;
        }
    }

    public static class CharValue
    extends Value {
        private final char value;

        public CharValue(char value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return "'" + SourceCodeEscapers.javaCharEscaper().escape(String.valueOf(this.value)) + "'";
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitChar(this.value, p);
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.CHAR;
        }

        public char value() {
            return this.value;
        }

        @Override
        public Object getValue() {
            return Character.valueOf(this.value);
        }

        @Override
        public int hashCode() {
            return Character.hashCode(this.value);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return obj instanceof CharValue && this.value == ((CharValue)obj).value;
        }
    }

    public static class LongValue
    extends Value {
        private final long value;

        public LongValue(long value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value + "L";
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitLong(this.value, p);
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.LONG;
        }

        public long value() {
            return this.value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.value);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return obj instanceof LongValue && this.value == ((LongValue)obj).value;
        }
    }

    public static class IntValue
    extends Value {
        private final int value;

        public IntValue(int value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitInt(this.value, p);
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.INT;
        }

        public int value() {
            return this.value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.value);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return obj instanceof IntValue && this.value == ((IntValue)obj).value;
        }
    }

    public static class BooleanValue
    extends Value {
        private final boolean value;

        public BooleanValue(boolean value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitBoolean(this.value, p);
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.BOOLEAN;
        }

        public boolean value() {
            return this.value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return Boolean.hashCode(this.value);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return obj instanceof BooleanValue && this.value == ((BooleanValue)obj).value();
        }
    }

    public static abstract class Value
    extends Const
    implements AnnotationValue {
        public abstract TurbineConstantTypeKind constantTypeKind();

        @Override
        public Kind kind() {
            return Kind.PRIMITIVE;
        }
    }

    public static class ConstCastError
    extends RuntimeException {
        public ConstCastError(TurbineConstantTypeKind type, TurbineConstantTypeKind target) {
            super(String.format("%s cannot be converted to %s", new Object[]{type, target}));
        }
    }

    public static enum Kind {
        ARRAY,
        PRIMITIVE,
        CLASS_LITERAL,
        ENUM_CONSTANT,
        ANNOTATION;

    }
}

