/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import java.lang.reflect.Array;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractArraySubject
extends Subject {
    private final @Nullable Object actual;

    AbstractArraySubject(FailureMetadata metadata, @Nullable Object actual, @Nullable String typeDescription) {
        super(metadata, actual, typeDescription);
        this.actual = actual;
    }

    public final void isEmpty() {
        if (this.length() > 0) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public final void isNotEmpty() {
        if (this.length() == 0) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public final void hasLength(int length) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"length (%s) must be >= 0", (int)length);
        this.check("length", new Object[0]).that(this.length()).isEqualTo(length);
    }

    private int length() {
        return Array.getLength(Preconditions.checkNotNull((Object)this.actual));
    }
}

