/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.Configuration;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AllBootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.AllInnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.attribute.visitor.NonEmptyAttributeFilter;
import proguard.classfile.attribute.visitor.RequiredAttributeFilter;
import proguard.classfile.constant.visitor.AllBootstrapMethodArgumentVisitor;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.constant.visitor.ConstantTagFilter;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.AccessFixer;
import proguard.classfile.editor.BridgeMethodFixer;
import proguard.classfile.editor.ClassReferenceFixer;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.InnerClassesAccessFixer;
import proguard.classfile.editor.MemberReferenceFixer;
import proguard.classfile.kotlin.visitor.AllConstructorVisitor;
import proguard.classfile.kotlin.visitor.AllFunctionVisitor;
import proguard.classfile.kotlin.visitor.AllPropertyVisitor;
import proguard.classfile.kotlin.visitor.AllTypeVisitor;
import proguard.classfile.kotlin.visitor.AllValueParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinClassToDefaultImplsClassVisitor;
import proguard.classfile.kotlin.visitor.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionToDefaultMethodVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataToClazzVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinValueParameterVisitor;
import proguard.classfile.kotlin.visitor.MethodToKotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.MultiKotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.filter.KotlinClassKindFilter;
import proguard.classfile.kotlin.visitor.filter.KotlinSyntheticClassKindFilter;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.util.WarningLogger;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.BottomClassFilter;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.DynamicReturnedClassVisitor;
import proguard.classfile.visitor.FunctionalInterfaceFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberProcessingFlagFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MethodFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.ProgramClassFilter;
import proguard.classfile.visitor.ProgramMemberFilter;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.fixer.kotlin.KotlinAnnotationFlagFixer;
import proguard.obfuscate.AttributeShrinker;
import proguard.obfuscate.AttributeUsageMarker;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.ClassRenamer;
import proguard.obfuscate.DictionaryNameFactory;
import proguard.obfuscate.MapCleaner;
import proguard.obfuscate.MappingKeeper;
import proguard.obfuscate.MappingPrinter;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MappingReader;
import proguard.obfuscate.MemberNameCollector;
import proguard.obfuscate.MemberNameConflictFixer;
import proguard.obfuscate.MemberObfuscator;
import proguard.obfuscate.MemberSpecialNameFilter;
import proguard.obfuscate.MultiMappingProcessor;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.NameMarker;
import proguard.obfuscate.NewMemberNameFilter;
import proguard.obfuscate.OriginalClassNameFilter;
import proguard.obfuscate.ParameterNameMarker;
import proguard.obfuscate.RenamedFlagSetter;
import proguard.obfuscate.SimpleNameFactory;
import proguard.obfuscate.SourceFileRenamer;
import proguard.obfuscate.SpecialNameFactory;
import proguard.obfuscate.kotlin.KotlinAliasNameObfuscator;
import proguard.obfuscate.kotlin.KotlinAliasReferenceFixer;
import proguard.obfuscate.kotlin.KotlinCallableReferenceFixer;
import proguard.obfuscate.kotlin.KotlinCompanionEqualizer;
import proguard.obfuscate.kotlin.KotlinDefaultImplsMethodNameEqualizer;
import proguard.obfuscate.kotlin.KotlinDefaultMethodNameEqualizer;
import proguard.obfuscate.kotlin.KotlinIntrinsicsReplacementSequences;
import proguard.obfuscate.kotlin.KotlinModuleNameObfuscator;
import proguard.obfuscate.kotlin.KotlinMultiFileFacadeFixer;
import proguard.obfuscate.kotlin.KotlinObjectFixer;
import proguard.obfuscate.kotlin.KotlinPropertyNameObfuscator;
import proguard.obfuscate.kotlin.KotlinPropertyRenamer;
import proguard.obfuscate.kotlin.KotlinSourceDebugExtensionAttributeObfuscator;
import proguard.obfuscate.kotlin.KotlinSyntheticClassFixer;
import proguard.obfuscate.kotlin.KotlinSyntheticToStringObfuscator;
import proguard.obfuscate.kotlin.KotlinUnsupportedExceptionReplacementSequences;
import proguard.obfuscate.kotlin.KotlinValueParameterNameShrinker;
import proguard.obfuscate.kotlin.KotlinValueParameterUsageMarker;
import proguard.obfuscate.util.InstructionSequenceObfuscator;
import proguard.pass.Pass;
import proguard.resources.file.visitor.ResourceFileProcessingFlagFilter;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.util.PrintWriterUtil;

public class Obfuscator
implements Pass {
    private static final Logger logger = LogManager.getLogger(Obfuscator.class);
    private final Configuration configuration;

    public Obfuscator(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(AppView appView) throws IOException {
        logger.info("Obfuscating...");
        PrintWriter out = new PrintWriter(System.out, true);
        BottomClassFilter memberInfoLinker = new BottomClassFilter((ClassVisitor)new MethodLinker());
        appView.programClassPool.classesAccept((ClassVisitor)memberInfoLinker);
        appView.libraryClassPool.classesAccept((ClassVisitor)memberInfoLinker);
        if (this.configuration.useUniqueClassMemberNames) {
            appView.programClassPool.classesAccept((ClassVisitor)new AllMemberVisitor((MemberVisitor)new MethodLinker()));
        }
        NameMarker nameMarker = new NameMarker();
        appView.libraryClassPool.classesAccept((ClassVisitor)nameMarker);
        appView.libraryClassPool.classesAccept((ClassVisitor)new AllMemberVisitor((MemberVisitor)nameMarker));
        appView.programClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ClassProcessingFlagFilter(0x400000, 0, (ClassVisitor)nameMarker), new AllMemberVisitor((MemberVisitor)new MemberProcessingFlagFilter(0x400000, 0, (MemberVisitor)nameMarker))}));
        appView.programClassPool.classesAccept((ClassVisitor)new ClassVersionFilter(0x330000, (ClassVisitor)new AllAttributeVisitor((AttributeVisitor)new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AllBootstrapMethodInfoVisitor((BootstrapMethodInfoVisitor)new AllBootstrapMethodArgumentVisitor((ConstantVisitor)new ConstantTagFilter(7, (ConstantVisitor)new ReferencedClassVisitor((ClassVisitor)new FunctionalInterfaceFilter((ClassVisitor)new ClassHierarchyTraveler(true, false, true, false, (ClassVisitor)new AllMethodVisitor((MemberVisitor)new MemberAccessFilter(1024, 0, (MemberVisitor)nameMarker))))))))))));
        appView.programClassPool.classesAccept((ClassVisitor)new ClassVersionFilter(0x330000, (ClassVisitor)new AllConstantVisitor((ConstantVisitor)new DynamicReturnedClassVisitor((ClassVisitor)new FunctionalInterfaceFilter((ClassVisitor)new ClassHierarchyTraveler(true, false, true, false, (ClassVisitor)new AllMethodVisitor((MemberVisitor)new MemberAccessFilter(1024, 0, (MemberVisitor)nameMarker))))))));
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept((ClassVisitor)new ClassProcessingFlagFilter(0x400000, 0, (ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinClassToDefaultImplsClassVisitor((ClassVisitor)nameMarker))));
        }
        NonEmptyAttributeFilter attributeUsageMarker = new NonEmptyAttributeFilter((AttributeVisitor)new AttributeUsageMarker());
        AttributeNameFilter optionalAttributeUsageMarker = this.configuration.keepAttributes == null ? null : new AttributeNameFilter(this.configuration.keepAttributes, (AttributeVisitor)attributeUsageMarker);
        appView.programClassPool.classesAccept((ClassVisitor)new AllAttributeVisitor(true, (AttributeVisitor)new RequiredAttributeFilter((AttributeVisitor)attributeUsageMarker, (AttributeVisitor)optionalAttributeUsageMarker)));
        if (this.configuration.keepParameterNames) {
            appView.programClassPool.classesAccept((ClassVisitor)new AllMethodVisitor((MemberVisitor)new NewMemberNameFilter((MemberVisitor)new AllAttributeVisitor(true, (AttributeVisitor)new ParameterNameMarker((AttributeVisitor)attributeUsageMarker)))));
            if (this.configuration.keepKotlinMetadata) {
                appView.programClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ClassAccessFilter(512, 0, (ClassVisitor)new AllMethodVisitor((MemberVisitor)new NewMemberNameFilter((MemberVisitor)new MethodToKotlinFunctionVisitor((KotlinFunctionVisitor)new AllValueParameterVisitor((KotlinValueParameterVisitor)new KotlinValueParameterUsageMarker()))))), new ClassAccessFilter(512, 0, (ClassVisitor)new ClassProcessingFlagFilter(0x400000, 0, (ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinClassKindFilter(metadata -> metadata.flags.isAnnotationClass, (KotlinMetadataVisitor)new AllConstructorVisitor((KotlinConstructorVisitor)new AllValueParameterVisitor((KotlinValueParameterVisitor)new KotlinValueParameterUsageMarker())))))), new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinValueParameterUsageMarker())}));
            }
        }
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinValueParameterNameShrinker()));
            appView.programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinSyntheticClassKindFilter(KotlinSyntheticClassKindFilter::isLambda, (KotlinMetadataVisitor)new KotlinMetadataToClazzVisitor((ClassVisitor)new AllAttributeVisitor((AttributeVisitor)new AttributeNameFilter("SourceDebugExtension", (AttributeVisitor)new MultiAttributeVisitor(new AttributeVisitor[]{attributeUsageMarker, new KotlinSourceDebugExtensionAttributeObfuscator()})))))));
        }
        appView.programClassPool.classesAccept((ClassVisitor)new AttributeShrinker());
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinAnnotationFlagFixer()));
        }
        if (this.configuration.applyMapping != null) {
            logger.info("Applying mapping from [{}]...", (Object)PrintWriterUtil.fileName(this.configuration.applyMapping));
            WarningLogger warningPrinter = new WarningLogger(logger, this.configuration.warn);
            MappingReader reader = new MappingReader(this.configuration.applyMapping);
            MultiMappingProcessor keeper = new MultiMappingProcessor(new MappingProcessor[]{new MappingKeeper(appView.programClassPool, (WarningPrinter)warningPrinter), new MappingKeeper(appView.libraryClassPool, null)});
            reader.pump(keeper);
            int warningCount = warningPrinter.getWarningCount();
            if (warningCount > 0) {
                logger.warn("Warning: there were {} kept classes and class members that were remapped anyway.", (Object)warningCount);
                logger.warn("         You should adapt your configuration or edit the mapping file.");
                if (!this.configuration.ignoreWarnings) {
                    logger.warn("         If you are sure this remapping won't hurt,");
                    logger.warn("         you could try your luck using the '-ignorewarnings' option.");
                }
                logger.warn("         (https://www.guardsquare.com/proguard/manual/troubleshooting#mappingconflict1)");
                if (!this.configuration.ignoreWarnings) {
                    throw new IOException("Please correct the above warnings first.");
                }
            }
        }
        DictionaryNameFactory classNameFactory = this.configuration.classObfuscationDictionary != null ? new DictionaryNameFactory(this.configuration.classObfuscationDictionary, null) : null;
        DictionaryNameFactory packageNameFactory = this.configuration.packageObfuscationDictionary != null ? new DictionaryNameFactory(this.configuration.packageObfuscationDictionary, null) : null;
        appView.programClassPool.classesAccept((ClassVisitor)new ClassObfuscator(appView.programClassPool, appView.libraryClassPool, classNameFactory, packageNameFactory, this.configuration.useMixedCaseClassNames, this.configuration.keepPackageNames, this.configuration.flattenPackageHierarchy, this.configuration.repackageClasses, this.configuration.allowAccessModification, this.configuration.keepKotlinMetadata));
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinCompanionEqualizer()));
        }
        NameFactory nameFactory = new SimpleNameFactory();
        if (this.configuration.obfuscationDictionary != null) {
            nameFactory = new DictionaryNameFactory(this.configuration.obfuscationDictionary, nameFactory);
        }
        WarningLogger warningPrinter = new WarningLogger(logger, this.configuration.warn);
        HashMap descriptorMap = new HashMap();
        if (this.configuration.useUniqueClassMemberNames) {
            appView.programClassPool.classesAccept((ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)));
            appView.programClassPool.classesAccept((ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberObfuscator(this.configuration.overloadAggressively, nameFactory, descriptorMap)));
        } else {
            appView.programClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ClassHierarchyTraveler(true, false, false, true, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(2, 0, (MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(true, true, true, true, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(0, 2, (MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(0, 2, (MemberVisitor)new MemberObfuscator(this.configuration.overloadAggressively, nameFactory, descriptorMap))), new MapCleaner(descriptorMap)}));
            appView.programClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new AllMemberVisitor((MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)), new ClassHierarchyTraveler(false, true, true, false, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(0, 2, (MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(false, false, false, true, (ClassVisitor)new ClassAccessFilter(1024, 0, (ClassVisitor)new ClassHierarchyTraveler(false, false, true, false, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap))))), new ClassHierarchyTraveler(false, false, false, true, (ClassVisitor)new ClassHierarchyTraveler(false, false, true, false, (ClassVisitor)new AllMethodVisitor((MemberVisitor)new MemberAccessFilter(0, 1032, (MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap))))), new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(2, 0, (MemberVisitor)new MemberObfuscator(this.configuration.overloadAggressively, nameFactory, descriptorMap))), new MapCleaner(descriptorMap)}));
        }
        SpecialNameFactory specialNameFactory = new SpecialNameFactory(new SimpleNameFactory());
        HashMap specialDescriptorMap = new HashMap();
        appView.programClassPool.classesAccept((ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberSpecialNameFilter(new MemberNameCollector(this.configuration.overloadAggressively, specialDescriptorMap))));
        appView.libraryClassPool.classesAccept((ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberSpecialNameFilter(new MemberNameCollector(this.configuration.overloadAggressively, specialDescriptorMap))));
        appView.programClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ClassHierarchyTraveler(true, false, false, true, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(2, 0, (MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(true, true, true, false, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(0, 2, (MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(true, true, true, false, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(0, 2, (MemberVisitor)new MemberNameConflictFixer(this.configuration.overloadAggressively, descriptorMap, (WarningPrinter)warningPrinter, new MemberObfuscator(this.configuration.overloadAggressively, specialNameFactory, specialDescriptorMap))))), new MapCleaner(descriptorMap)}));
        appView.programClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new AllMemberVisitor((MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)), new ClassHierarchyTraveler(false, true, true, false, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(0, 2, (MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(2, 0, (MemberVisitor)new MemberNameConflictFixer(this.configuration.overloadAggressively, descriptorMap, (WarningPrinter)warningPrinter, new MemberObfuscator(this.configuration.overloadAggressively, specialNameFactory, specialDescriptorMap)))), new MapCleaner(descriptorMap)}));
        int warningCount = warningPrinter.getWarningCount();
        if (warningCount > 0) {
            logger.warn("Warning: there were {} conflicting class member name mappings.", (Object)warningCount);
            logger.warn("         Your configuration may be inconsistent.");
            if (!this.configuration.ignoreWarnings) {
                logger.warn("         If you are sure the conflicts are harmless,");
                logger.warn("         you could try your luck using the '-ignorewarnings' option.");
            }
            logger.warn("         (https://www.guardsquare.com/proguard/manual/troubleshooting#mappingconflict2)");
            if (!this.configuration.ignoreWarnings) {
                throw new IOException("Please correct the above warnings first.");
            }
        }
        appView.programClassPool.classesAccept((ClassVisitor)new InstructionSequenceObfuscator(new KotlinIntrinsicsReplacementSequences(appView.programClassPool, appView.libraryClassPool)));
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new MultiKotlinMetadataVisitor(new KotlinMetadataVisitor[]{new KotlinPropertyNameObfuscator(nameFactory), new KotlinAliasNameObfuscator(nameFactory), new KotlinSyntheticClassFixer(), new KotlinObjectFixer(), new AllFunctionVisitor(new KotlinFunctionVisitor[]{new KotlinDefaultImplsMethodNameEqualizer(), new KotlinDefaultMethodNameEqualizer(), new KotlinFunctionToDefaultMethodVisitor((MemberVisitor)new InstructionSequenceObfuscator(new KotlinUnsupportedExceptionReplacementSequences(appView.programClassPool, appView.libraryClassPool)))}), new KotlinClassKindFilter(kc -> kc.flags.isValue || kc.flags.isData, (KotlinMetadataVisitor)new KotlinSyntheticToStringObfuscator())}))}));
            appView.resourceFilePool.resourceFilesAccept((ResourceFileVisitor)new ResourceFileProcessingFlagFilter(0, 0x400000, (ResourceFileVisitor)new KotlinModuleNameObfuscator(nameFactory)));
        }
        if (this.configuration.printMapping != null) {
            logger.info("Printing mapping to [{}]...", (Object)PrintWriterUtil.fileName(this.configuration.printMapping));
            PrintWriter mappingWriter = PrintWriterUtil.createPrintWriter(this.configuration.printMapping, out);
            try {
                appView.programClassPool.classesAcceptAlphabetically((ClassVisitor)new MappingPrinter(mappingWriter));
            }
            finally {
                PrintWriterUtil.closePrintWriter(this.configuration.printMapping, mappingWriter);
            }
        }
        if (this.configuration.addConfigurationDebugging) {
            appView.programClassPool.classesAccept((ClassVisitor)new RenamedFlagSetter());
        }
        ClassCounter obfuscatedClassCounter = new ClassCounter();
        MemberCounter obfuscatedFieldCounter = new MemberCounter();
        MemberCounter obfuscatedMethodCounter = new MemberCounter();
        ClassRenamer classRenamer = new ClassRenamer((ClassVisitor)new ProgramClassFilter((ClassVisitor)obfuscatedClassCounter), (MemberVisitor)new ProgramMemberFilter((MemberVisitor)new MethodFilter((MemberVisitor)obfuscatedMethodCounter, (MemberVisitor)obfuscatedFieldCounter)));
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinMultiFileFacadeFixer()));
        }
        appView.programClassPool.classesAccept((ClassVisitor)classRenamer);
        appView.libraryClassPool.classesAccept((ClassVisitor)classRenamer);
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new AllPropertyVisitor((KotlinPropertyVisitor)new KotlinPropertyRenamer())));
        }
        appView.programClassPool.classesAccept((ClassVisitor)new ClassReferenceFixer(false));
        appView.libraryClassPool.classesAccept((ClassVisitor)new ClassReferenceFixer(false));
        appView.programClassPool.classesAccept((ClassVisitor)new MemberReferenceFixer(this.configuration.android));
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new MultiKotlinMetadataVisitor(new KotlinMetadataVisitor[]{new AllTypeVisitor((KotlinTypeVisitor)new KotlinAliasReferenceFixer()), new KotlinCallableReferenceFixer(appView.programClassPool, appView.libraryClassPool)})));
        }
        if (this.configuration.repackageClasses != null && this.configuration.allowAccessModification) {
            appView.programClassPool.classesAccept((ClassVisitor)new AccessFixer());
            appView.programClassPool.classesAccept((ClassVisitor)new OriginalClassNameFilter(null, (ClassVisitor)new AllAttributeVisitor((AttributeVisitor)new AllInnerClassesInfoVisitor((InnerClassesInfoVisitor)new InnerClassesAccessFixer()))));
        }
        appView.programClassPool.classesAccept((ClassVisitor)new AllMethodVisitor((MemberVisitor)new BridgeMethodFixer()));
        if (this.configuration.newSourceFileAttribute != null) {
            appView.programClassPool.classesAccept((ClassVisitor)new SourceFileRenamer(this.configuration.newSourceFileAttribute));
        }
        appView.programClassPool.classesAccept((ClassVisitor)new ConstantPoolShrinker());
        logger.info("  Number of obfuscated classes:                  {}", (Object)obfuscatedClassCounter.getCount());
        logger.info("  Number of obfuscated fields:                   {}", (Object)obfuscatedFieldCounter.getCount());
        logger.info("  Number of obfuscated methods:                  {}", (Object)obfuscatedMethodCounter.getCount());
    }
}

