/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.refaster.AutoValue_UNewArray;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.URepeated;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import org.jspecify.annotations.Nullable;

@AutoValue
abstract class UNewArray
extends UExpression
implements NewArrayTree {
    UNewArray() {
    }

    public static UNewArray create(UExpression type, List<? extends UExpression> dimensions, List<? extends UExpression> initializers) {
        return new AutoValue_UNewArray(type, (ImmutableList<UExpression>)(dimensions != null ? ImmutableList.copyOf(dimensions) : null), (ImmutableList<UExpression>)(initializers != null ? ImmutableList.copyOf(initializers) : null));
    }

    @Override
    public abstract @Nullable UExpression getType();

    public abstract @Nullable ImmutableList<UExpression> getDimensions();

    public abstract @Nullable ImmutableList<UExpression> getInitializers();

    @Override
    public @Nullable Choice<Unifier> visitNewArray(NewArrayTree newArray, @Nullable Unifier unifier) {
        boolean hasRepeated = this.getInitializers() != null && Iterables.any(this.getInitializers(), (Predicate)Predicates.instanceOf(URepeated.class));
        return Unifier.unifyNullable(unifier, this.getType(), newArray.getType()).flatMap(Unifier.unifications(this.getDimensions(), newArray.getDimensions())).flatMap(Unifier.unifications(this.getInitializers(), newArray.getInitializers(), hasRepeated));
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.NEW_ARRAY;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitNewArray(this, data);
    }

    @Override
    public JCTree.JCNewArray inline(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.maker().NewArray(this.getType() == null ? null : (JCTree.JCExpression)this.getType().inline(inliner), this.getDimensions() == null ? null : inliner.inlineList(this.getDimensions()), this.getInitializers() == null ? null : inliner.inlineList(this.getInitializers()));
    }

    @Override
    public List<? extends AnnotationTree> getAnnotations() {
        return ImmutableList.of();
    }

    @Override
    public List<? extends List<? extends AnnotationTree>> getDimAnnotations() {
        return ImmutableList.of();
    }
}

