/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.HijrahDate;
import java.time.chrono.HijrahEra;
import java.time.chrono.IsoEra;
import java.time.chrono.JapaneseDate;
import java.time.chrono.JapaneseEra;
import java.time.chrono.MinguoDate;
import java.time.chrono.MinguoEra;
import java.time.chrono.ThaiBuddhistDate;
import java.time.chrono.ThaiBuddhistEra;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;

@BugPattern(summary="TemporalAccessor.get() only works for certain values of ChronoField.", explanation="TemporalAccessor.get(ChronoField) only works for certain values of ChronoField. E.g., DayOfWeek only supports DAY_OF_WEEK. All other values are guaranteed to throw an UnsupportedTemporalTypeException.", severity=BugPattern.SeverityLevel.ERROR)
public final class TemporalAccessorGetChronoField
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ZoneId ARBITRARY_ZONE = ZoneId.of("America/Los_Angeles");
    private static final ImmutableList<TemporalAccessor> TEMPORAL_ACCESSOR_INSTANCES = ImmutableList.of((Object)DayOfWeek.MONDAY, (Object)HijrahDate.now(ARBITRARY_ZONE), (Object)HijrahEra.AH, (Object)Instant.now(), (Object)IsoEra.CE, (Object)JapaneseDate.now(ARBITRARY_ZONE), (Object)JapaneseEra.SHOWA, (Object)LocalDate.now(ARBITRARY_ZONE), (Object)LocalDateTime.now(ARBITRARY_ZONE), (Object)LocalTime.now(ARBITRARY_ZONE), (Object)MinguoDate.now(ARBITRARY_ZONE), (Object)MinguoEra.ROC, (Object[])new TemporalAccessor[]{Month.MAY, MonthDay.now(ARBITRARY_ZONE), OffsetDateTime.now(ARBITRARY_ZONE), OffsetTime.now(ARBITRARY_ZONE), ThaiBuddhistDate.now(ARBITRARY_ZONE), ThaiBuddhistEra.BE, Year.now(ARBITRARY_ZONE), YearMonth.now(ARBITRARY_ZONE), ZonedDateTime.now(ARBITRARY_ZONE), ZoneOffset.ofHours(8)});
    private static final ImmutableListMultimap<String, ChronoField> UNSUPPORTED = TemporalAccessorGetChronoField.buildUnsupported();

    private static ImmutableListMultimap<String, ChronoField> buildUnsupported() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (TemporalAccessor temporalAccessor : TEMPORAL_ACCESSOR_INSTANCES) {
            for (ChronoField chronoField : ChronoField.values()) {
                if (temporalAccessor.isSupported(chronoField)) continue;
                builder.put((Object)temporalAccessor.getClass().getCanonicalName(), (Object)chronoField);
            }
        }
        return builder.build();
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        Name methodName = sym.name;
        if (!methodName.contentEquals("get") && !methodName.contentEquals("getLong")) {
            return Description.NO_MATCH;
        }
        List<Symbol.VarSymbol> params = sym.params();
        if (params.size() != 1) {
            return Description.NO_MATCH;
        }
        Name argType = ((Symbol.VarSymbol)params.get((int)0)).type.tsym.getQualifiedName();
        if (!argType.contentEquals("java.time.temporal.TemporalField")) {
            return Description.NO_MATCH;
        }
        String declaringType = sym.owner.getQualifiedName().toString();
        ImmutableList invalidChronoFields = UNSUPPORTED.get((Object)declaringType);
        if (invalidChronoFields != null && TemporalAccessorGetChronoField.isDefinitelyInvalidChronoField(tree, (Iterable<ChronoField>)invalidChronoFields)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static boolean isDefinitelyInvalidChronoField(MethodInvocationTree tree, Iterable<ChronoField> invalidChronoFields) {
        return TemporalAccessorGetChronoField.getEnumName((ExpressionTree)Iterables.getOnlyElement(tree.getArguments())).map(constant -> Streams.stream((Iterable)invalidChronoFields).map(Enum::name).anyMatch(constant::equals)).orElse(false);
    }

    private static Optional<String> getEnumName(ExpressionTree chronoField) {
        if (chronoField instanceof IdentifierTree) {
            IdentifierTree identifierTree = (IdentifierTree)chronoField;
            return Optional.of(identifierTree.getName().toString());
        }
        if (chronoField instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)chronoField;
            return Optional.of(memberSelectTree.getIdentifier().toString());
        }
        return Optional.empty();
    }
}

