/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.auto.value.AutoValue;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_GuardedByExpression_ClassLiteral;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_GuardedByExpression_LocalVariable;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_GuardedByExpression_Select;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_GuardedByExpression_TypeLiteral;
import com.google.errorprone.bugpatterns.threadsafety.IllegalGuardedBy;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.Objects;
import javax.lang.model.element.ElementKind;

public abstract class GuardedByExpression {
    static final String ENCLOSING_INSTANCE_NAME = "outer$";

    public abstract Kind kind();

    public abstract Symbol sym();

    public abstract Type type();

    public String toString() {
        return PrettyPrinter.print(this);
    }

    public String debugPrint() {
        return DebugPrinter.print(this);
    }

    private static class PrettyPrinter {
        private PrettyPrinter() {
        }

        public static String print(GuardedByExpression exp) {
            StringBuilder sb = new StringBuilder();
            PrettyPrinter.pprint(exp, sb);
            return sb.toString();
        }

        private static void pprint(GuardedByExpression exp, StringBuilder sb) {
            switch (exp.kind().ordinal()) {
                case 1: {
                    sb.append(String.format("%s.class", exp.sym().name));
                    break;
                }
                case 0: {
                    sb.append("this");
                    break;
                }
                case 2: 
                case 3: {
                    sb.append(exp.sym().name);
                    break;
                }
                case 4: {
                    PrettyPrinter.pprintSelect((Select)exp, sb);
                    break;
                }
                case 5: {
                    sb.append(((Erroneous)exp).guardString());
                }
            }
        }

        private static void pprintSelect(Select exp, StringBuilder sb) {
            if (exp.sym().name.contentEquals(GuardedByExpression.ENCLOSING_INSTANCE_NAME)) {
                GuardedByExpression curr = exp.base();
                while (curr.kind() == Kind.SELECT && (curr = ((Select)curr).base()).kind() != Kind.THIS) {
                }
                if (curr.kind() == Kind.THIS) {
                    sb.append(String.format("%s.this", exp.sym().owner.name));
                } else {
                    PrettyPrinter.pprint(exp.base(), sb);
                    sb.append(".this$0");
                }
            } else {
                PrettyPrinter.pprint(exp.base(), sb);
                sb.append(String.format(".%s", exp.sym().name));
                if (exp.sym().getKind() == ElementKind.METHOD) {
                    sb.append("()");
                }
            }
        }
    }

    private static class DebugPrinter {
        private DebugPrinter() {
        }

        public static String print(GuardedByExpression exp) {
            StringBuilder sb = new StringBuilder();
            DebugPrinter.pprint(exp, sb);
            return sb.toString();
        }

        private static void pprint(GuardedByExpression exp, StringBuilder sb) {
            switch (exp.kind().ordinal()) {
                case 1: 
                case 2: 
                case 3: {
                    sb.append(String.format("(%s %s)", new Object[]{exp.kind(), exp.sym()}));
                    break;
                }
                case 0: {
                    sb.append("(THIS)");
                    break;
                }
                case 4: {
                    DebugPrinter.pprintSelect((Select)exp, sb);
                    break;
                }
                case 5: {
                    sb.append("(ERROR)");
                }
            }
        }

        private static void pprintSelect(Select exp, StringBuilder sb) {
            sb.append(String.format("(%s ", new Object[]{exp.kind()}));
            DebugPrinter.pprint(exp.base(), sb);
            if (exp.sym().name.contentEquals(GuardedByExpression.ENCLOSING_INSTANCE_NAME)) {
                sb.append(String.format(" %s%s)", GuardedByExpression.ENCLOSING_INSTANCE_NAME, exp.sym().owner));
            } else {
                sb.append(String.format(" %s)", exp.sym()));
            }
        }
    }

    public static enum Kind {
        THIS,
        CLASS_LITERAL,
        TYPE_LITERAL,
        LOCAL_VARIABLE,
        SELECT,
        ERROR;

    }

    public static class Factory {
        ThisLiteral thisliteral() {
            return ThisLiteral.INSTANCE;
        }

        GuardedByExpression qualifiedThis(Names names, Symbol.ClassSymbol access, Symbol enclosing) {
            GuardedByExpression base = this.thisliteral();
            Symbol.ClassSymbol curr = access;
            while ((curr = ASTHelpers.enclosingClass((Symbol)curr)) != null) {
                base = this.select(base, new EnclosingInstanceSymbol(names, curr));
                if (!curr.equals(enclosing)) continue;
            }
            IllegalGuardedBy.checkGuardedBy(curr != null, "Expected an enclosing class.");
            return base;
        }

        ClassLiteral classLiteral(Symbol clazz) {
            return ClassLiteral.create(clazz);
        }

        TypeLiteral typeLiteral(Symbol type) {
            return TypeLiteral.create(type);
        }

        Select select(GuardedByExpression base, Symbol member) {
            if (member instanceof Symbol.VarSymbol) {
                Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)member;
                return this.select(base, varSymbol);
            }
            if (member instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)member;
                return this.select(base, methodSymbol);
            }
            throw new IllegalStateException("Bad select expression: expected symbol " + String.valueOf((Object)member.getKind()));
        }

        Select select(GuardedByExpression base, Symbol.VarSymbol member) {
            return Select.create(base, member, member.type);
        }

        Select select(GuardedByExpression base, Symbol.MethodSymbol member) {
            return Select.create(base, member, member.getReturnType());
        }

        GuardedByExpression select(GuardedByExpression base, Select select) {
            return Select.create(base, select.sym(), select.type());
        }

        LocalVariable localVariable(Symbol.VarSymbol varSymbol) {
            return LocalVariable.create(varSymbol);
        }

        Erroneous error(String guardString) {
            return new Erroneous(guardString);
        }

        private static class EnclosingInstanceSymbol
        extends Symbol.VarSymbol {
            public EnclosingInstanceSymbol(Names names, Symbol curr) {
                super(4096L, names.fromString(GuardedByExpression.ENCLOSING_INSTANCE_NAME), curr.type, curr);
            }

            @Override
            public int hashCode() {
                return Objects.hash(GuardedByExpression.ENCLOSING_INSTANCE_NAME, this.owner.hashCode());
            }

            @Override
            public boolean equals(Object other) {
                if (!(other instanceof Symbol.VarSymbol)) {
                    return false;
                }
                Symbol.VarSymbol that = (Symbol.VarSymbol)other;
                if (!((Name)that.getSimpleName()).contentEquals(GuardedByExpression.ENCLOSING_INSTANCE_NAME)) {
                    return false;
                }
                return this.owner.equals(that.owner);
            }
        }
    }

    @AutoValue
    public static abstract class Select
    extends GuardedByExpression {
        public abstract GuardedByExpression base();

        public static Select create(GuardedByExpression base, Symbol sym, Type type) {
            return new AutoValue_GuardedByExpression_Select(Kind.SELECT, sym, type, base);
        }

        public GuardedByExpression root() {
            GuardedByExpression exp = this.base();
            while (exp.kind() == Kind.SELECT) {
                exp = ((Select)exp).base();
            }
            return exp;
        }
    }

    public static class ThisLiteral
    extends GuardedByExpression {
        static final ThisLiteral INSTANCE = new ThisLiteral();

        @Override
        public Kind kind() {
            return Kind.THIS;
        }

        @Override
        public Symbol sym() {
            return null;
        }

        @Override
        public Type type() {
            return null;
        }

        private ThisLiteral() {
        }
    }

    public static class Erroneous
    extends GuardedByExpression {
        private final String guardString;

        Erroneous(String guardString) {
            this.guardString = guardString;
        }

        @Override
        public Kind kind() {
            return Kind.ERROR;
        }

        @Override
        public Symbol sym() {
            return null;
        }

        @Override
        public Type type() {
            return null;
        }

        public String guardString() {
            return this.guardString;
        }
    }

    @AutoValue
    public static abstract class LocalVariable
    extends GuardedByExpression {
        public static LocalVariable create(Symbol owner) {
            return new AutoValue_GuardedByExpression_LocalVariable(Kind.LOCAL_VARIABLE, owner, owner.type);
        }
    }

    @AutoValue
    public static abstract class TypeLiteral
    extends GuardedByExpression {
        public static TypeLiteral create(Symbol owner) {
            return new AutoValue_GuardedByExpression_TypeLiteral(Kind.TYPE_LITERAL, owner, owner.type);
        }
    }

    @AutoValue
    public static abstract class ClassLiteral
    extends GuardedByExpression {
        public static ClassLiteral create(Symbol owner) {
            return new AutoValue_GuardedByExpression_ClassLiteral(Kind.CLASS_LITERAL, owner, owner.type);
        }
    }
}

