/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import java.util.List;
import java.util.Optional;

@BugPattern(summary="Nullness annotations directly on type parameters are interpreted differently by different tools", severity=BugPattern.SeverityLevel.WARNING)
public class NullableTypeParameter
extends BugChecker
implements BugChecker.TypeParameterTreeMatcher {
    public Description matchTypeParameter(TypeParameterTree tree, VisitorState state) {
        Optional nullness = NullnessAnnotations.fromAnnotationTrees(tree.getAnnotations());
        if (nullness.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, this.fix(tree.getAnnotations(), tree, state));
    }

    Fix fix(List<? extends AnnotationTree> annotations, TypeParameterTree tree, VisitorState state) {
        ImmutableList existingAnnotations = NullnessAnnotations.annotationsRelevantToNullness(annotations);
        if (existingAnnotations.size() != 1) {
            return SuggestedFix.emptyFix();
        }
        AnnotationTree existingAnnotation = (AnnotationTree)Iterables.getOnlyElement((Iterable)existingAnnotations);
        SuggestedFix.Builder fix = SuggestedFix.builder().delete((Tree)existingAnnotation);
        List<? extends Tree> bounds = tree.getBounds();
        if (bounds.stream().anyMatch(b -> {
            AnnotatedTypeTree annotatedTypeTree;
            return b instanceof AnnotatedTypeTree && NullnessAnnotations.fromAnnotationTrees((annotatedTypeTree = (AnnotatedTypeTree)b).getAnnotations()).isPresent();
        })) {
            return SuggestedFix.emptyFix();
        }
        if (bounds.isEmpty()) {
            return fix.postfixWith((Tree)tree, String.format(" extends %s Object", state.getSourceForNode((Tree)existingAnnotation))).build();
        }
        String prefix = String.format("%s ", state.getSourceForNode((Tree)existingAnnotation));
        bounds.forEach(bound -> fix.prefixWith(bound, prefix));
        return fix.build();
    }
}

