/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ArgumentChangeFinder;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Changes;
import com.google.errorprone.bugpatterns.argumentselectiondefects.CreatesDuplicateCallHeuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.InvocationInfo;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Matchers;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Parameter;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ParameterPair;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.function.Function;

@BugPattern(summary="Arguments to AutoValue constructor are in the wrong order", severity=BugPattern.SeverityLevel.ERROR)
public final class AutoValueConstructorOrderChecker
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private final ArgumentChangeFinder argumentChangeFinder = ArgumentChangeFinder.builder().setDistanceFunction(AutoValueConstructorOrderChecker.buildDistanceFunction()).addHeuristic(AutoValueConstructorOrderChecker::allArgumentsMustMatch).addHeuristic(new CreatesDuplicateCallHeuristic()).build();

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!Matchers.isAutoValueConstructor(tree)) {
            return Description.NO_MATCH;
        }
        InvocationInfo invocationInfo = InvocationInfo.createFromNewClass(tree, ASTHelpers.getSymbol((NewClassTree)tree), state);
        Changes changes = this.argumentChangeFinder.findChanges(invocationInfo);
        if (changes.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(invocationInfo.tree(), (Fix)changes.buildPermuteArgumentsFix(invocationInfo));
    }

    private static Function<ParameterPair, Double> buildDistanceFunction() {
        return new Function<ParameterPair, Double>(){

            @Override
            public Double apply(ParameterPair parameterPair) {
                Parameter formal = parameterPair.formal();
                Parameter actual = parameterPair.actual();
                if (formal.isUnknownName() || actual.isUnknownName()) {
                    return formal.index() == actual.index() ? 0.0 : 1.0;
                }
                return formal.name().equals(actual.name()) ? 0.0 : 1.0;
            }
        };
    }

    private static boolean allArgumentsMustMatch(Changes changes, Tree node, Symbol.MethodSymbol sym, VisitorState state) {
        return changes.assignmentCost().stream().allMatch(c -> c < 1.0);
    }
}

