/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;

@BugPattern(summary="To return a custom message with a Throwable class, one should override getMessage() instead of toString().", severity=BugPattern.SeverityLevel.WARNING)
public final class OverrideThrowableToString
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        if (!Matchers.toStringMethodDeclaration().matches((Tree)methodTree, state)) {
            return Description.NO_MATCH;
        }
        ClassTree classTree = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
        if (!ASTHelpers.isSubtype((Type)ASTHelpers.getType((ClassTree)classTree), (Type)state.getSymtab().throwableType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (classTree.getMembers().stream().filter(m -> m instanceof MethodTree).map(m -> (MethodTree)m).anyMatch(m -> m.getName().contentEquals("getMessage"))) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(methodTree, (Fix)SuggestedFixes.renameMethod((MethodTree)methodTree, (String)"getMessage", (VisitorState)state));
    }
}

