/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.lang.model.type.TypeMirror;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Prefer assertThrows to ExpectedException", severity=BugPattern.SeverityLevel.WARNING)
public class ExpectedExceptionChecker
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    static final Matcher<StatementTree> MATCHER = Matchers.expressionStatement((Matcher)MethodMatchers.instanceMethod().onExactClass("org.junit.rules.ExpectedException").withNameMatching(Pattern.compile("expect.*")));
    static final Matcher<ExpressionTree> IS_A = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClassAny(new String[]{"org.hamcrest.Matchers", "org.hamcrest.CoreMatchers", "org.hamcrest.core.Is"}).withSignature("<T>isA(java.lang.Class<T>)"), MethodMatchers.staticMethod().onClassAny(new String[]{"org.hamcrest.Matchers", "org.hamcrest.CoreMatchers", "org.hamcrest.core.Is"}).withSignature("<T>isA(java.lang.Class<?>)")});
    static final Matcher<StatementTree> FAIL_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.throwStatement((Matcher)Matchers.anything()), Matchers.expressionStatement((Matcher)MethodMatchers.staticMethod().anyClass().named("fail"))});
    private static final Matcher<StatementTree> TRUTH_ASSERT_THAT = Matchers.expressionStatement((Matcher)Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.receiverOfInvocation((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.truth.Truth").namedAnyOf(new String[]{"assertThat"}), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("that")}))));
    private static final Supplier<Symbol> ORG_HAMCREST_MATCHER_SYMBOL = VisitorState.memoize((Supplier & Serializable)state -> state.getSymbolFromString("org.hamcrest.Matcher"));
    private static final Supplier<Type> ORG_HAMCREST_MATCHER_TYPE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("org.hamcrest.Matcher"));

    public Description matchMethod(final MethodTree tree, final VisitorState state) {
        if (tree.getBody() == null) {
            return Description.NO_MATCH;
        }
        tree.getBody().accept(new TreeScanner<Void, Void>(this){
            final /* synthetic */ ExpectedExceptionChecker this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitBlock(BlockTree block, Void unused) {
                Description description = this.this$0.scanBlock(tree, block, state);
                if (description != Description.NO_MATCH) {
                    state.reportMatch(description);
                }
                return (Void)super.visitBlock(block, null);
            }
        }, null);
        return Description.NO_MATCH;
    }

    Description scanBlock(MethodTree tree, BlockTree block, VisitorState state) {
        PeekingIterator it = Iterators.peekingIterator(block.getStatements().iterator());
        while (it.hasNext() && !MATCHER.matches((Tree)((StatementTree)it.peek()), state)) {
            it.next();
        }
        ArrayList<Tree> expectations = new ArrayList<Tree>();
        while (it.hasNext() && MATCHER.matches((Tree)((StatementTree)it.peek()), state)) {
            expectations.add((Tree)it.next());
        }
        if (expectations.isEmpty()) {
            return Description.NO_MATCH;
        }
        ArrayDeque suffix = new ArrayDeque();
        StatementTree failure = null;
        Iterators.addAll(suffix, (Iterator)it);
        if (!suffix.isEmpty() && FAIL_MATCHER.matches((Tree)((StatementTree)suffix.peekLast()), state)) {
            failure = (StatementTree)suffix.removeLast();
        }
        while (!suffix.isEmpty() && TRUTH_ASSERT_THAT.matches((Tree)((StatementTree)suffix.peekLast()), state)) {
            suffix.removeLast();
        }
        return this.handleMatch(tree, state, expectations, (List<StatementTree>)ImmutableList.copyOf(suffix), failure);
    }

    private Description handleMatch(MethodTree tree, VisitorState state, List<Tree> expectations, List<StatementTree> suffix, @Nullable StatementTree failure) {
        return this.describeMatch(tree, ExpectedExceptionChecker.buildFix(state, expectations, failure, suffix));
    }

    private static Fix buildFix(VisitorState state, List<Tree> expectations, @Nullable StatementTree failure, List<StatementTree> suffix) {
        Type exceptionType = state.getSymtab().throwableType;
        ArrayList<String> newAsserts = new ArrayList<String>();
        SuggestedFix.Builder fix = SuggestedFix.builder();
        block10: for (Tree expectation : expectations) {
            MethodInvocationTree invocation = (MethodInvocationTree)((ExpressionStatementTree)expectation).getExpression();
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)invocation);
            Symtab symtab = state.getSymtab();
            List<? extends ExpressionTree> args = invocation.getArguments();
            switch (((Name)symbol.getSimpleName()).toString()) {
                case "expect": {
                    Type matchType;
                    Type type = ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(invocation.getArguments())));
                    if (ASTHelpers.isSubtype((Type)type, (Type)symtab.classType, (VisitorState)state)) {
                        exceptionType = ASTHelpers.getUpperBound((Type)((Type)Iterables.getFirst(state.getTypes().asSuper(type, symtab.classType.tsym).getTypeArguments(), (Object)symtab.throwableType)), (Types)state.getTypes());
                        break;
                    }
                    if (!ASTHelpers.isSubtype((Type)type, (Type)((Type)ORG_HAMCREST_MATCHER_TYPE.get(state)), (VisitorState)state)) continue block10;
                    Type matcherType = state.getTypes().asSuper(type, (Symbol)ORG_HAMCREST_MATCHER_SYMBOL.get(state));
                    if (!matcherType.getTypeArguments().isEmpty() && ASTHelpers.isSubtype((Type)(matchType = (Type)Iterables.getOnlyElement(matcherType.getTypeArguments())), (Type)symtab.throwableType, (VisitorState)state)) {
                        exceptionType = matchType;
                    }
                    fix.addStaticImport("org.hamcrest.MatcherAssert.assertThat");
                    newAsserts.add(String.format("assertThat(thrown, %s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                    break;
                }
                case "expectCause": {
                    ExpressionTree matcher = (ExpressionTree)Iterables.getOnlyElement(invocation.getArguments());
                    if (IS_A.matches((Tree)matcher, state)) {
                        fix.addStaticImport("com.google.common.truth.Truth.assertThat");
                        newAsserts.add(String.format("assertThat(thrown).hasCauseThat().isInstanceOf(%s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(((MethodInvocationTree)matcher).getArguments()))));
                        break;
                    }
                    fix.addStaticImport("org.hamcrest.MatcherAssert.assertThat");
                    newAsserts.add(String.format("assertThat(thrown.getCause(), %s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                    break;
                }
                case "expectMessage": {
                    if (ASTHelpers.isSubtype((Type)((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)symbol.getParameters())).asType(), (Type)symtab.stringType, (VisitorState)state)) {
                        fix.addStaticImport("com.google.common.truth.Truth.assertThat");
                        newAsserts.add(String.format("assertThat(thrown).hasMessageThat().contains(%s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                        break;
                    }
                    fix.addStaticImport("org.hamcrest.MatcherAssert.assertThat");
                    newAsserts.add(String.format("assertThat(thrown.getMessage(), %s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown expect method: " + String.valueOf(symbol.getSimpleName())));
                }
            }
        }
        fix.replace(ASTHelpers.getStartPosition((Tree)expectations.get(0)), state.getEndPosition((Tree)Iterables.getLast(expectations)), "");
        if (failure != null) {
            fix.delete((Tree)failure);
        }
        return ExpectedExceptionChecker.finishFix(fix.build(), exceptionType, newAsserts, suffix, state);
    }

    private static SuggestedFix finishFix(SuggestedFix baseFix, Type exceptionType, List<String> newAsserts, List<StatementTree> throwingStatements, VisitorState state) {
        boolean useExpressionLambda;
        if (throwingStatements.isEmpty()) {
            return baseFix;
        }
        SuggestedFix.Builder fix = baseFix.toBuilder();
        fix.addStaticImport("org.junit.Assert.assertThrows");
        StringBuilder fixPrefix = new StringBuilder();
        String exceptionTypeName = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (TypeMirror)exceptionType);
        if (!newAsserts.isEmpty()) {
            fixPrefix.append(String.format("%s thrown = ", exceptionTypeName));
        }
        fixPrefix.append("assertThrows");
        fixPrefix.append(String.format("(%s.class, () -> ", exceptionTypeName));
        boolean bl = useExpressionLambda = throwingStatements.size() == 1 && Iterables.getOnlyElement(throwingStatements) instanceof ExpressionStatementTree;
        if (!useExpressionLambda) {
            fixPrefix.append("{");
        }
        fix.prefixWith((Tree)throwingStatements.get(0), fixPrefix.toString());
        if (useExpressionLambda) {
            fix.postfixWith((Tree)((ExpressionStatementTree)throwingStatements.get(0)).getExpression(), ")");
            fix.postfixWith((Tree)Iterables.getLast(throwingStatements), "\n" + Joiner.on((char)'\n').join(newAsserts));
        } else {
            fix.postfixWith((Tree)Iterables.getLast(throwingStatements), "});\n" + Joiner.on((char)'\n').join(newAsserts));
        }
        return fix.build();
    }
}

