/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import javax.lang.model.type.TypeKind;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Compile-time constant expression overflows", severity=BugPattern.SeverityLevel.ERROR)
public class ConstantOverflow
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final SimpleTreeVisitor<Number, Void> CONSTANT_VISITOR = new SimpleTreeVisitor<Number, Void>(){

        @Override
        public @Nullable Number visitConditionalExpression(ConditionalExpressionTree node, Void p) {
            Number ifTrue = node.getTrueExpression().accept(this, null);
            Number ifFalse = node.getFalseExpression().accept(this, null);
            Boolean condition = (Boolean)ASTHelpers.constValue((Tree)node.getCondition(), Boolean.class);
            if (condition == null) {
                return null;
            }
            return condition != false ? (Number)ifTrue : (Number)ifFalse;
        }

        @Override
        public Number visitParenthesized(ParenthesizedTree node, Void p) {
            return node.getExpression().accept(this, null);
        }

        @Override
        public @Nullable Number visitUnary(UnaryTree node, Void p) {
            Number value = node.getExpression().accept(this, null);
            if (value == null) {
                return null;
            }
            if (value instanceof Long) {
                return ConstantOverflow.unop(node.getKind(), value.longValue());
            }
            return ConstantOverflow.unop(node.getKind(), value.intValue());
        }

        @Override
        public @Nullable Number visitBinary(BinaryTree node, Void p) {
            Number lhs = node.getLeftOperand().accept(this, null);
            Number rhs = node.getRightOperand().accept(this, null);
            if (lhs == null || rhs == null) {
                return null;
            }
            switch (node.getKind()) {
                case MINUS: {
                    if ((!(lhs instanceof Long) || lhs.longValue() != Long.MIN_VALUE) && (!(lhs instanceof Integer) || lhs.intValue() != Integer.MIN_VALUE)) break;
                    return null;
                }
                case PLUS: {
                    if ((!(lhs instanceof Long) || lhs.longValue() != Long.MAX_VALUE) && (!(lhs instanceof Integer) || lhs.intValue() != Integer.MAX_VALUE)) break;
                    return null;
                }
            }
            if (lhs instanceof Long || rhs instanceof Long) {
                return ConstantOverflow.binop(node.getKind(), lhs.longValue(), rhs.longValue());
            }
            return ConstantOverflow.binop(node.getKind(), lhs.intValue(), rhs.intValue());
        }

        @Override
        public @Nullable Number visitTypeCast(TypeCastTree node, Void p) {
            Number value = node.getExpression().accept(this, null);
            if (value == null) {
                return null;
            }
            Tree tree = node.getType();
            if (!(tree instanceof PrimitiveTypeTree)) {
                return null;
            }
            PrimitiveTypeTree primitiveTypeTree = (PrimitiveTypeTree)tree;
            TypeKind kind = primitiveTypeTree.getPrimitiveTypeKind();
            return ConstantOverflow.cast(kind, value);
        }

        @Override
        public Number visitMemberSelect(MemberSelectTree node, Void p) {
            return ConstantOverflow.getIntegralConstant(node);
        }

        @Override
        public Number visitIdentifier(IdentifierTree node, Void p) {
            return ConstantOverflow.getIntegralConstant(node);
        }

        @Override
        public Number visitLiteral(LiteralTree node, Void unused) {
            return ConstantOverflow.getIntegralConstant(node);
        }
    };

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        for (TreePath path = state.getPath().getParentPath(); path != null && path.getLeaf() instanceof ExpressionTree; path = path.getParentPath()) {
            if (!(path.getLeaf() instanceof BinaryTree)) continue;
            return Description.NO_MATCH;
        }
        try {
            tree.accept(CONSTANT_VISITOR, null);
            return Description.NO_MATCH;
        }
        catch (ArithmeticException e) {
            Description.Builder description = this.buildDescription(tree);
            Fix longFix = ConstantOverflow.longFix(tree, state);
            if (longFix != null) {
                description.addFix(longFix);
            }
            return description.build();
        }
    }

    private static @Nullable Fix longFix(ExpressionTree expr, VisitorState state) {
        BinaryTree binExpr = null;
        while (expr instanceof BinaryTree) {
            binExpr = (BinaryTree)expr;
            expr = binExpr.getLeftOperand();
        }
        if (!(expr instanceof LiteralTree) || expr.getKind() != Tree.Kind.INT_LITERAL) {
            return null;
        }
        Type.JCPrimitiveType intType = state.getSymtab().intType;
        if (!ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)binExpr), (Type)intType, (VisitorState)state)) {
            return null;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder().postfixWith((Tree)expr, "L");
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof VariableTree) {
            VariableTree variableTree = (VariableTree)parent;
            if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)parent), (Type)intType, (VisitorState)state) && !ASTHelpers.hasImplicitType((VariableTree)variableTree, (VisitorState)state)) {
                fix.replace(variableTree.getType(), "long");
            }
        }
        return fix.build();
    }

    private static @Nullable Long unop(Tree.Kind kind, long value) {
        return switch (kind) {
            case Tree.Kind.UNARY_PLUS -> value;
            case Tree.Kind.UNARY_MINUS -> -value;
            case Tree.Kind.BITWISE_COMPLEMENT -> value ^ 0xFFFFFFFFFFFFFFFFL;
            default -> null;
        };
    }

    private static @Nullable Integer unop(Tree.Kind kind, int value) {
        return switch (kind) {
            case Tree.Kind.UNARY_PLUS -> value;
            case Tree.Kind.UNARY_MINUS -> -value;
            case Tree.Kind.BITWISE_COMPLEMENT -> ~value;
            default -> null;
        };
    }

    static @Nullable Long binop(Tree.Kind kind, long lhs, long rhs) {
        return switch (kind) {
            case Tree.Kind.MULTIPLY -> LongMath.checkedMultiply((long)lhs, (long)rhs);
            case Tree.Kind.DIVIDE -> lhs / rhs;
            case Tree.Kind.REMAINDER -> lhs % rhs;
            case Tree.Kind.PLUS -> LongMath.checkedAdd((long)lhs, (long)rhs);
            case Tree.Kind.MINUS -> LongMath.checkedSubtract((long)lhs, (long)rhs);
            case Tree.Kind.LEFT_SHIFT -> lhs << (int)rhs;
            case Tree.Kind.RIGHT_SHIFT -> lhs >> (int)rhs;
            case Tree.Kind.UNSIGNED_RIGHT_SHIFT -> lhs >>> (int)rhs;
            case Tree.Kind.AND -> lhs & rhs;
            case Tree.Kind.XOR -> lhs ^ rhs;
            case Tree.Kind.OR -> lhs | rhs;
            default -> null;
        };
    }

    static @Nullable Integer binop(Tree.Kind kind, int lhs, int rhs) {
        return switch (kind) {
            case Tree.Kind.MULTIPLY -> IntMath.checkedMultiply((int)lhs, (int)rhs);
            case Tree.Kind.DIVIDE -> lhs / rhs;
            case Tree.Kind.REMAINDER -> lhs % rhs;
            case Tree.Kind.PLUS -> IntMath.checkedAdd((int)lhs, (int)rhs);
            case Tree.Kind.MINUS -> IntMath.checkedSubtract((int)lhs, (int)rhs);
            case Tree.Kind.LEFT_SHIFT -> lhs << rhs;
            case Tree.Kind.RIGHT_SHIFT -> lhs >> rhs;
            case Tree.Kind.UNSIGNED_RIGHT_SHIFT -> lhs >>> rhs;
            case Tree.Kind.AND -> lhs & rhs;
            case Tree.Kind.XOR -> lhs ^ rhs;
            case Tree.Kind.OR -> lhs | rhs;
            default -> null;
        };
    }

    private static @Nullable Number cast(TypeKind kind, Number value) {
        return switch (kind) {
            case TypeKind.SHORT -> value.shortValue();
            case TypeKind.INT -> value.intValue();
            case TypeKind.LONG -> value.longValue();
            case TypeKind.BYTE -> value.byteValue();
            case TypeKind.CHAR -> (int)((char)value.intValue());
            default -> null;
        };
    }

    private static @Nullable Number getIntegralConstant(Tree node) {
        Number number = (Number)ASTHelpers.constValue((Tree)node, Number.class);
        if (number instanceof Integer || number instanceof Long) {
            return number;
        }
        return null;
    }
}

