/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.reachingdef;

import java.util.List;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.analysis.ForwardTransferFunction;
import org.checkerframework.errorprone.dataflow.analysis.RegularTransferResult;
import org.checkerframework.errorprone.dataflow.analysis.TransferInput;
import org.checkerframework.errorprone.dataflow.analysis.TransferResult;
import org.checkerframework.errorprone.dataflow.analysis.UnusedAbstractValue;
import org.checkerframework.errorprone.dataflow.cfg.UnderlyingAST;
import org.checkerframework.errorprone.dataflow.cfg.node.AbstractNodeVisitor;
import org.checkerframework.errorprone.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.errorprone.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.reachingdef.ReachingDefinitionNode;
import org.checkerframework.errorprone.dataflow.reachingdef.ReachingDefinitionStore;

public class ReachingDefinitionTransfer
extends AbstractNodeVisitor<TransferResult<UnusedAbstractValue, ReachingDefinitionStore>, TransferInput<UnusedAbstractValue, ReachingDefinitionStore>>
implements ForwardTransferFunction<UnusedAbstractValue, ReachingDefinitionStore> {
    @Override
    public ReachingDefinitionStore initialStore(UnderlyingAST underlyingAST, @Nullable List<LocalVariableNode> parameters) {
        return new ReachingDefinitionStore();
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, ReachingDefinitionStore> visitNode(Node n, TransferInput<UnusedAbstractValue, ReachingDefinitionStore> p) {
        return new RegularTransferResult<Object, ReachingDefinitionStore>(null, p.getRegularStore());
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, ReachingDefinitionStore> visitAssignment(AssignmentNode n, TransferInput<UnusedAbstractValue, ReachingDefinitionStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitAssignment(n, p);
        this.processDefinition(n, (ReachingDefinitionStore)transferResult.getRegularStore());
        return transferResult;
    }

    private void processDefinition(AssignmentNode def, ReachingDefinitionStore store) {
        store.killDef(def.getTarget());
        store.putDef(new ReachingDefinitionNode(def));
    }
}

