/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.kotlin;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.visitor.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.ProgramMethodOptimizationInfo;

public class KotlinContextReceiverUsageMarker
implements KotlinMetadataVisitor,
KotlinFunctionVisitor,
KotlinConstructorVisitor,
KotlinPropertyVisitor {
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        kotlinClassKindMetadata.constructorsAccept(clazz, (KotlinConstructorVisitor)this);
    }

    public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        this.markContextReceiverParameters(kotlinFunctionMetadata.contextReceivers, kotlinFunctionMetadata.referencedMethod, kotlinFunctionMetadata.referencedDefaultMethod);
    }

    public void visitConstructor(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata) {
        this.markContextReceiverParameters(kotlinClassKindMetadata.contextReceivers, kotlinConstructorMetadata.referencedMethod);
    }

    public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
        this.markContextReceiverParameters(kotlinPropertyMetadata.contextReceivers, kotlinPropertyMetadata.referencedGetterMethod, kotlinPropertyMetadata.referencedSetterMethod);
    }

    private void markContextReceiverParameters(List<KotlinTypeMetadata> contextReceivers, Method ... methods) {
        if (contextReceivers == null) {
            return;
        }
        Function<Method, Boolean> isStatic = method -> (method.getAccessFlags() & 8) != 0;
        IntStream.range(0, contextReceivers.size()).forEach(paramIndex -> Arrays.stream(methods).filter(Objects::nonNull).filter(it -> it.getProcessingInfo() instanceof ProgramMethodOptimizationInfo).forEachOrdered(it -> ParameterUsageMarker.markParameterUsed(it, (Boolean)isStatic.apply((Method)it) != false ? paramIndex : paramIndex + 1)));
    }
}

