/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.info.SimpleEnumMarker;

public class SimpleEnumFilter
implements ClassVisitor {
    private final ClassVisitor simpleEnumClassVisitor;
    private final ClassVisitor otherClassVisitor;

    public SimpleEnumFilter(ClassVisitor simpleEnumClassVisitor) {
        this(simpleEnumClassVisitor, null);
    }

    public SimpleEnumFilter(ClassVisitor simpleEnumClassVisitor, ClassVisitor otherClassVisitor) {
        this.simpleEnumClassVisitor = simpleEnumClassVisitor;
        this.otherClassVisitor = otherClassVisitor;
    }

    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    public void visitProgramClass(ProgramClass programClass) {
        ClassVisitor classVisitor;
        ClassVisitor classVisitor2 = classVisitor = SimpleEnumMarker.isSimpleEnum((Clazz)programClass) ? this.simpleEnumClassVisitor : this.otherClassVisitor;
        if (classVisitor != null) {
            classVisitor.visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        if (this.otherClassVisitor != null) {
            this.otherClassVisitor.visitLibraryClass(libraryClass);
        }
    }
}

