/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.CharMatcher;
import com.google.common.base.Converter;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Range;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.ImmutableValueGraph;
import com.google.common.hash.HashCode;
import com.google.common.io.BaseEncoding;
import com.google.common.net.MediaType;
import com.google.common.primitives.Primitives;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.bugpatterns.ImmutableCollections;
import com.google.errorprone.bugpatterns.threadsafety.AnnotationInfo;
import com.google.errorprone.bugpatterns.threadsafety.ThreadSafetyKnownTypes;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.tools.javac.code.Type;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Inject;

@Immutable
public final class WellKnownMutability
implements ThreadSafetyKnownTypes {
    private final ImmutableMap<String, AnnotationInfo> knownImmutableClasses;
    private final ImmutableSet<String> knownMutableClasses;
    private static final Supplier<Type> MESSAGE_TYPE = Suppliers.typeFromString((String)"com.google.protobuf.MessageLite");
    private static final Supplier<Type> MUTABLE_MESSAGE_TYPE = Suppliers.typeFromString((String)"com.google.protobuf.MutableMessageLite");
    private static final Supplier<Type> PROTOCOL_MESSAGE_TYPE = Suppliers.typeFromString((String)"com.google.io.protocol.ProtocolMessage");
    private static final Supplier<Type> PROTOCOL_MESSAGE_ENUM = Suppliers.typeFromString((String)"com.google.protobuf.Internal.EnumLite");

    @Inject
    WellKnownMutability(ErrorProneFlags flags) {
        ImmutableList immutable = flags.getListOrEmpty("Immutable:KnownImmutable");
        ImmutableList mutable = (ImmutableList)Stream.of("Immutable:KnownMutable", "Immutable:KnownUnsafe").flatMap(f -> flags.getListOrEmpty(f).stream()).collect(ImmutableList.toImmutableList());
        this.knownImmutableClasses = WellKnownMutability.buildImmutableClasses((List<String>)immutable);
        this.knownMutableClasses = WellKnownMutability.buildMutableClasses((List<String>)mutable);
    }

    public static WellKnownMutability fromFlags(ErrorProneFlags flags) {
        return new WellKnownMutability(flags);
    }

    public ImmutableMap<String, AnnotationInfo> getKnownImmutableClasses() {
        return this.knownImmutableClasses;
    }

    @Override
    @Deprecated
    public ImmutableMap<String, AnnotationInfo> getKnownSafeClasses() {
        return this.getKnownImmutableClasses();
    }

    public ImmutableSet<String> getKnownMutableClasses() {
        return this.knownMutableClasses;
    }

    @Override
    @Deprecated
    public ImmutableSet<String> getKnownUnsafeClasses() {
        return this.getKnownMutableClasses();
    }

    private static ImmutableMap<String, AnnotationInfo> buildImmutableClasses(List<String> extraKnownImmutables) {
        return new ThreadSafetyKnownTypes.MapBuilder().addStrings(extraKnownImmutables).addClasses(Primitives.allPrimitiveTypes()).addClasses(Primitives.allWrapperTypes()).add("com.github.zafarkhaja.semver.Version", new String[0]).add("com.google.protobuf.ByteString", new String[0]).add("com.google.protobuf.Descriptors$Descriptor", new String[0]).add("com.google.protobuf.Descriptors$EnumDescriptor", new String[0]).add("com.google.protobuf.Descriptors$EnumValueDescriptor", new String[0]).add("com.google.protobuf.Descriptors$FieldDescriptor", new String[0]).add("com.google.protobuf.Descriptors$FileDescriptor", new String[0]).add("com.google.protobuf.Descriptors$OneofDescriptor", new String[0]).add("com.google.protobuf.Descriptors$ServiceDescriptor", new String[0]).add("com.google.protobuf.Extension", new String[0]).add("com.google.protobuf.ExtensionRegistry$ExtensionInfo", new String[0]).add("com.google.protobuf.GeneratedMessage", new String[0]).add("com.google.protobuf.Parser", new String[0]).add("com.google.re2j.Pattern", new String[0]).add("com.google.inject.TypeLiteral", new String[0]).add("com.google.inject.Key", new String[0]).add(CharMatcher.class, new String[0]).add(Converter.class, new String[0]).add(Joiner.class, new String[0]).add(Optional.class, "T").add(Splitter.class, new String[0]).add(ContiguousSet.class, "C").add(ImmutableBiMap.class, "K", "V").add(ImmutableCollection.class, "E").add(ImmutableList.class, "E").add(ImmutableListMultimap.class, "K", "V").add(ImmutableMap.class, "K", "V").add(ImmutableMultimap.class, "K", "V").add(ImmutableMultiset.class, "E").add(ImmutableRangeMap.class, "K", "V").add(ImmutableRangeSet.class, "C").add(ImmutableSet.class, "E").add(ImmutableSetMultimap.class, "K", "V").add(ImmutableSortedMap.class, "K", "V").add(ImmutableSortedMultiset.class, "E").add(ImmutableSortedSet.class, "E").add(ImmutableTable.class, "R", "C", "V").add(Range.class, "C").add(ImmutableGraph.class, "N").add(ImmutableNetwork.class, "N", "E").add(ImmutableValueGraph.class, "N", "V").add("com.google.common.hash.AbstractHashFunction", new String[0]).add(HashCode.class, new String[0]).add(BaseEncoding.class, new String[0]).add(MediaType.class, new String[0]).add(UnsignedInteger.class, new String[0]).add(UnsignedLong.class, new String[0]).add("com.ibm.icu.number.LocalizedNumberFormatter", new String[0]).add("com.ibm.icu.number.LocalizedNumberRangeFormatter", new String[0]).add("com.ibm.icu.number.UnlocalizedNumberFormatter", new String[0]).add("com.ibm.icu.number.UnlocalizedNumberRangeFormatter", new String[0]).add("com.ibm.icu.util.Currency", new String[0]).add("com.ibm.icu.util.ULocale", new String[0]).add(Class.class, new String[0]).add(Enum.class, "E").add(String.class, new String[0]).add(Annotation.class, new String[0]).add(BigDecimal.class, new String[0]).add(BigInteger.class, new String[0]).add(Inet4Address.class, new String[0]).add(Inet6Address.class, new String[0]).add(InetAddress.class, new String[0]).add(URI.class, new String[0]).add(HttpClient.class, new String[0]).add(ByteOrder.class, new String[0]).add(Charset.class, new String[0]).add(Path.class, new String[0]).add(WatchEvent.class, new String[0]).add(AclEntry.class, new String[0]).add(FileTime.class, new String[0]).add(UUID.class, new String[0]).add(Locale.class, new String[0]).add(Pattern.class, new String[0]).add("android.net.Uri", new String[0]).add("android.util.Size", new String[0]).add("java.awt.Color", new String[0]).add("java.lang.invoke.MethodHandle", new String[0]).add("java.util.AbstractMap$SimpleImmutableEntry", "K", "V").add("java.util.Optional", "T").add("java.util.OptionalDouble", new String[0]).add("java.util.OptionalInt", new String[0]).add("java.util.OptionalLong", new String[0]).add("java.time.Clock", new String[0]).add("java.time.Duration", new String[0]).add("java.time.Instant", new String[0]).add("java.time.LocalDate", new String[0]).add("java.time.LocalDateTime", new String[0]).add("java.time.LocalTime", new String[0]).add("java.time.MonthDay", new String[0]).add("java.time.OffsetDateTime", new String[0]).add("java.time.OffsetTime", new String[0]).add("java.time.Period", new String[0]).add("java.time.Year", new String[0]).add("java.time.YearMonth", new String[0]).add("java.time.ZoneId", new String[0]).add("java.time.ZoneOffset", new String[0]).add("java.time.ZonedDateTime", new String[0]).add("java.time.chrono.AbstractChronology", new String[0]).add("java.time.chrono.ChronoLocalDate", new String[0]).add("java.time.chrono.ChronoLocalDateTime", "D").add("java.time.chrono.ChronoPeriod", new String[0]).add("java.time.chrono.ChronoZonedDateTime", "D").add("java.time.chrono.Chronology", new String[0]).add("java.time.chrono.Era", new String[0]).add("java.time.chrono.HijrahChronology", new String[0]).add("java.time.chrono.HijrahDate", new String[0]).add("java.time.chrono.IsoChronology", new String[0]).add("java.time.chrono.JapaneseChronology", new String[0]).add("java.time.chrono.JapaneseDate", new String[0]).add("java.time.chrono.JapaneseEra", new String[0]).add("java.time.chrono.MinguoChronology", new String[0]).add("java.time.chrono.MinguoDate", new String[0]).add("java.time.chrono.ThaiBuddhistChronology", new String[0]).add("java.time.chrono.ThaiBuddhistDate", new String[0]).add("java.time.format.DateTimeFormatter", new String[0]).add("java.time.format.DecimalStyle", new String[0]).add("java.time.temporal.TemporalField", new String[0]).add("java.time.temporal.TemporalUnit", new String[0]).add("java.time.temporal.ValueRange", new String[0]).add("java.time.temporal.WeekFields", new String[0]).add("java.time.zone.ZoneOffsetTransition", new String[0]).add("java.time.zone.ZoneOffsetTransitionRule", new String[0]).add("java.time.zone.ZoneRules", new String[0]).add("java.time.zone.ZoneRulesProvider", new String[0]).add("kotlin.Unit", new String[0]).add("kotlin.Pair", "A", "B").add("kotlin.Triple", "A", "B", "C").add("kotlin.time.Duration", new String[0]).add("kotlin.ranges.IntRange", new String[0]).add("kotlin.ranges.LongRange", new String[0]).add("kotlin.ranges.UIntRange", new String[0]).add("kotlin.ranges.ULongRange", new String[0]).add("org.threeten.bp.Duration", new String[0]).add("org.threeten.bp.Instant", new String[0]).add("org.threeten.bp.LocalDate", new String[0]).add("org.threeten.bp.LocalDateTime", new String[0]).add("org.threeten.bp.LocalTime", new String[0]).add("org.threeten.bp.MonthDay", new String[0]).add("org.threeten.bp.OffsetDateTime", new String[0]).add("org.threeten.bp.OffsetTime", new String[0]).add("org.threeten.bp.Period", new String[0]).add("org.threeten.bp.Year", new String[0]).add("org.threeten.bp.YearMonth", new String[0]).add("org.threeten.bp.ZoneId", new String[0]).add("org.threeten.bp.ZoneOffset", new String[0]).add("org.threeten.bp.ZonedDateTime", new String[0]).add("org.threeten.bp.chrono.AbstractChronology", new String[0]).add("org.threeten.bp.chrono.ChronoLocalDate", new String[0]).add("org.threeten.bp.chrono.ChronoLocalDateTime", "D").add("org.threeten.bp.chrono.ChronoPeriod", new String[0]).add("org.threeten.bp.chrono.ChronoZonedDateTime", "D").add("org.threeten.bp.chrono.Chronology", new String[0]).add("org.threeten.bp.chrono.Era", new String[0]).add("org.threeten.bp.chrono.HijrahChronology", new String[0]).add("org.threeten.bp.chrono.HijrahDate", new String[0]).add("org.threeten.bp.chrono.IsoChronology", new String[0]).add("org.threeten.bp.chrono.JapaneseChronology", new String[0]).add("org.threeten.bp.chrono.JapaneseDate", new String[0]).add("org.threeten.bp.chrono.JapaneseEra", new String[0]).add("org.threeten.bp.chrono.MinguoChronology", new String[0]).add("org.threeten.bp.chrono.MinguoDate", new String[0]).add("org.threeten.bp.chrono.ThaiBuddhistChronology", new String[0]).add("org.threeten.bp.chrono.ThaiBuddhistDate", new String[0]).add("org.threeten.bp.format.DateTimeFormatter", new String[0]).add("org.threeten.bp.format.DecimalStyle", new String[0]).add("org.threeten.bp.temporal.TemporalField", new String[0]).add("org.threeten.bp.temporal.TemporalUnit", new String[0]).add("org.threeten.bp.temporal.ValueRange", new String[0]).add("org.threeten.bp.temporal.WeekFields", new String[0]).add("org.threeten.bp.zone.ZoneOffsetTransition", new String[0]).add("org.threeten.bp.zone.ZoneOffsetTransitionRule", new String[0]).add("org.threeten.bp.zone.ZoneRules", new String[0]).add("org.threeten.bp.zone.ZoneRulesProvider", new String[0]).add("org.threeten.extra.DayOfMonth", new String[0]).add("org.threeten.extra.DayOfYear", new String[0]).add("org.threeten.extra.Days", new String[0]).add("org.threeten.extra.Hours", new String[0]).add("org.threeten.extra.Interval", new String[0]).add("org.threeten.extra.LocalDateRange", new String[0]).add("org.threeten.extra.Minutes", new String[0]).add("org.threeten.extra.Months", new String[0]).add("org.threeten.extra.PeriodDuration", new String[0]).add("org.threeten.extra.Seconds", new String[0]).add("org.threeten.extra.Weeks", new String[0]).add("org.threeten.extra.YearQuarter", new String[0]).add("org.threeten.extra.YearWeek", new String[0]).add("org.threeten.extra.Years", new String[0]).add("org.joda.time.DateTime", new String[0]).add("org.joda.time.DateTimeZone", new String[0]).add("org.joda.time.Days", new String[0]).add("org.joda.time.Duration", new String[0]).add("org.joda.time.Instant", new String[0]).add("org.joda.time.Interval", new String[0]).add("org.joda.time.LocalDate", new String[0]).add("org.joda.time.LocalDateTime", new String[0]).add("org.joda.time.Period", new String[0]).add("org.joda.time.format.DateTimeFormatter", new String[0]).add("org.openqa.selenium.Dimension", new String[0]).add("org.openqa.selenium.DeviceRotation", new String[0]).add("org.openqa.selenium.ImmutableCapabilities", new String[0]).build();
    }

    private static ImmutableSet<String> buildMutableClasses(List<String> knownMutables) {
        return ImmutableSet.builder().addAll(knownMutables).addAll((Iterable)ImmutableCollections.MUTABLE_TO_IMMUTABLE_CLASS_NAME_MAP.keySet()).add((Object)"com.google.common.util.concurrent.AtomicDouble").add((Object)"com.google.protobuf.util.FieldMaskUtil.MergeOptions").add((Object)BitSet.class.getName()).add((Object)Calendar.class.getName()).add((Object)Iterable.class.getName()).add((Object)Object.class.getName()).add((Object)"java.text.DateFormat").add((Object)ArrayList.class.getName()).add((Object)Collection.class.getName()).add((Object)EnumMap.class.getName()).add((Object)EnumSet.class.getName()).add((Object)List.class.getName()).add((Object)Logger.class.getName()).add((Object)Map.class.getName()).add((Object)HashMap.class.getName()).add((Object)HashSet.class.getName()).add((Object)NavigableMap.class.getName()).add((Object)NavigableSet.class.getName()).add((Object)Random.class.getName()).add((Object)TreeMap.class.getName()).add((Object)TreeSet.class.getName()).add((Object)Vector.class.getName()).add((Object)Set.class.getName()).add((Object)AtomicBoolean.class.getName()).add((Object)AtomicReference.class.getName()).add((Object)AtomicLong.class.getName()).build();
    }

    private static boolean isAssignableTo(Type type, Supplier<Type> supplier, VisitorState state) {
        Type to = (Type)supplier.get(state);
        if (to == null) {
            return false;
        }
        to = state.getTypes().erasure(to);
        return state.getTypes().isAssignable(type, to);
    }

    public static boolean isProto2MessageClass(VisitorState state, Type type) {
        Preconditions.checkNotNull((Object)type);
        return WellKnownMutability.isAssignableTo(type, MESSAGE_TYPE, state) && !WellKnownMutability.isAssignableTo(type, PROTOCOL_MESSAGE_TYPE, state);
    }

    public static boolean isProto2MutableMessageClass(VisitorState state, Type type) {
        Preconditions.checkNotNull((Object)type);
        return WellKnownMutability.isAssignableTo(type, MUTABLE_MESSAGE_TYPE, state) && !WellKnownMutability.isAssignableTo(type, PROTOCOL_MESSAGE_TYPE, state);
    }

    public static boolean isProtoEnum(VisitorState state, Type type) {
        Preconditions.checkNotNull((Object)type);
        return WellKnownMutability.isAssignableTo(type, PROTOCOL_MESSAGE_ENUM, state);
    }

    public static boolean isAnnotation(VisitorState state, Type type) {
        return WellKnownMutability.isAssignableTo(type, (Supplier<Type>)Suppliers.ANNOTATION_TYPE, state);
    }
}

