/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableListMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.HashSet;
import java.util.Map;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="Certain wildcard types can confuse the compiler.", severity=BugPattern.SeverityLevel.ERROR)
public class UnsafeWildcard
extends BugChecker
implements BugChecker.AssignmentTreeMatcher,
BugChecker.ClassTreeMatcher,
BugChecker.ConditionalExpressionTreeMatcher,
BugChecker.LambdaExpressionTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.ParenthesizedTreeMatcher,
BugChecker.ReturnTreeMatcher,
BugChecker.TypeCastTreeMatcher,
BugChecker.VariableTreeMatcher {
    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        return this.checkForUnsafeNullAssignment(((JCTree.JCExpression)tree.getVariable()).type, tree.getExpression(), state);
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)tree;
        for (JCTree.JCExpression implemented : classDecl.getImplementsClause()) {
            state.reportMatch(this.checkForUnsafeWildcards(implemented, "Unsafe wildcard type: ", implemented.type, state));
        }
        if (classDecl.getExtendsClause() != null) {
            return this.checkForUnsafeWildcards(classDecl.getExtendsClause(), "Unsafe wildcard type: ", classDecl.getExtendsClause().type, state);
        }
        return Description.NO_MATCH;
    }

    public Description matchConditionalExpression(ConditionalExpressionTree tree, VisitorState state) {
        Type ternaryType = ((JCTree.JCExpression)((Object)tree)).type;
        state.reportMatch(this.checkForUnsafeNullAssignment(ternaryType, tree.getTrueExpression(), state));
        return this.checkForUnsafeNullAssignment(ternaryType, tree.getFalseExpression(), state);
    }

    public Description matchLambdaExpression(LambdaExpressionTree tree, VisitorState state) {
        Tree tree2 = tree.getBody();
        if (tree2 instanceof ExpressionTree) {
            ExpressionTree expressionTree = (ExpressionTree)tree2;
            Type targetType = ((JCTree.JCLambda)tree).getDescriptorType(state.getTypes()).getReturnType();
            return this.checkForUnsafeNullAssignment(targetType, expressionTree, state);
        }
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Type.MethodType mtype = (Type.MethodType)((JCTree.JCMethodInvocation)tree).meth.type;
        Symbol.MethodSymbol callee = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (!((List)((JCTree.JCMethodInvocation)tree).getTypeArguments()).isEmpty()) {
            for (JCTree.JCExpression typearg : ((JCTree.JCMethodInvocation)tree).getTypeArguments()) {
                state.reportMatch(this.checkForUnsafeWildcards(typearg, "Unsafe wildcard type: ", typearg.type, state));
            }
        } else if (!callee.type.getTypeArguments().isEmpty()) {
            ImmutableListMultimap mapping = ASTHelpers.getTypeSubstitution((Type)mtype, (Symbol)callee);
            HashSet<Type> seen = new HashSet<Type>();
            for (Map.Entry inferredTypearg : mapping.entries()) {
                if (!seen.add((Type)inferredTypearg.getValue())) continue;
                state.reportMatch(this.checkForUnsafeWildcards(tree, "Unsafe wildcard in inferred type argument for callee's type parameter " + String.valueOf(inferredTypearg.getKey()) + ": ", (Type)inferredTypearg.getValue(), state));
            }
        }
        int paramIndex = 0;
        for (ExpressionTree expressionTree : tree.getArguments()) {
            Type paramType = mtype.argtypes.get(paramIndex);
            state.reportMatch(this.checkForUnsafeNullAssignment(paramType, expressionTree, state));
            paramIndex = Math.min(paramIndex + 1, mtype.argtypes.size() - 1);
        }
        return Description.NO_MATCH;
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        Type.MethodType mtype = (Type.MethodType)((JCTree.JCNewClass)tree).constructorType;
        int paramIndex = tree.getClassBody() != null && tree.getEnclosingExpression() != null ? 1 : 0;
        for (ExpressionTree expressionTree : tree.getArguments()) {
            Type paramType = mtype.argtypes.get(paramIndex);
            state.reportMatch(this.checkForUnsafeNullAssignment(paramType, expressionTree, state));
            paramIndex = Math.min(paramIndex + 1, mtype.argtypes.size() - 1);
        }
        return this.checkForUnsafeWildcards(tree, "Unsafe wildcard type argument: ", ((JCTree.JCNewClass)tree).type, state);
    }

    public Description matchParenthesized(ParenthesizedTree tree, VisitorState state) {
        return this.checkForUnsafeNullAssignment(((JCTree.JCParens)tree).type, tree.getExpression(), state);
    }

    public Description matchReturn(ReturnTree tree, VisitorState state) {
        if (tree.getExpression() == null || ((JCTree.JCExpression)tree.getExpression()).type.getKind() != TypeKind.NULL) {
            return Description.NO_MATCH;
        }
        Tree method = state.findEnclosing(new Class[]{MethodTree.class, LambdaExpressionTree.class});
        if (method instanceof MethodTree) {
            return this.checkForUnsafeNullAssignment(((JCTree.JCMethodDecl)method).getReturnType().type, tree.getExpression(), state);
        }
        if (method instanceof LambdaExpressionTree) {
            Type targetType = ((JCTree.JCLambda)method).getDescriptorType(state.getTypes()).getReturnType();
            return this.checkForUnsafeNullAssignment(targetType, tree.getExpression(), state);
        }
        return Description.NO_MATCH;
    }

    public Description matchTypeCast(TypeCastTree tree, VisitorState state) {
        return this.checkForUnsafeNullAssignment(((JCTree.JCTypeCast)tree).getType().type, tree.getExpression(), state);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (tree.getInitializer() != null) {
            return this.checkForUnsafeNullAssignment(((JCTree.JCVariableDecl)tree).type, tree.getInitializer(), state);
        }
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (symbol.getKind() == ElementKind.FIELD && (symbol.flags() & 0x10L) == 0L) {
            return this.checkForUnsafeWildcards(tree, "Uninitialized field with unsafe wildcard type: ", ((JCTree.JCVariableDecl)tree).type, state);
        }
        return Description.NO_MATCH;
    }

    private Description checkForUnsafeNullAssignment(Type targetType, ExpressionTree tree, VisitorState state) {
        if (!targetType.isReference() || ((JCTree.JCExpression)tree).type.getKind() != TypeKind.NULL) {
            return Description.NO_MATCH;
        }
        return this.checkForUnsafeWildcards(tree, "Cast to wildcard type unsafe: ", targetType, state);
    }

    private Description checkForUnsafeWildcards(Tree tree, String messageHeader, Type targetType, VisitorState state) {
        Description contained;
        while (targetType instanceof Type.ArrayType) {
            targetType = ((Type.ArrayType)targetType).getComponentType();
        }
        int i = 0;
        for (Type arg : targetType.getTypeArguments()) {
            Type.WildcardType wildcardType;
            Type.WildcardType wildcardType2;
            if (arg instanceof Type.WildcardType && (wildcardType2 = (Type.WildcardType)arg).getSuperBound() != null) {
                Description contained3;
                Type lowerBound = wildcardType2.getSuperBound();
                Type boundVar = targetType.tsym.type.getTypeArguments().get(i);
                if (lowerBound.getUpperBound() != null && lowerBound.getUpperBound().toString().endsWith("java.lang.Object")) {
                    if (!state.getTypes().isSubtypeNoCapture(lowerBound, boundVar.getUpperBound())) {
                        return this.buildDescription(tree).setMessage(messageHeader + String.valueOf(targetType) + " because of type argument " + i + " with implicit upper bound " + String.valueOf(boundVar.getUpperBound())).build();
                    }
                } else if (state.getTypes().isSubtypeNoCapture(boundVar.getUpperBound(), lowerBound) && !state.getTypes().isSameType(boundVar.getUpperBound(), lowerBound)) {
                    return this.buildDescription(tree).setMessage(messageHeader + String.valueOf(targetType) + " because of impossible type argument " + i + " with implicit upper bound " + String.valueOf(boundVar.getUpperBound())).build();
                }
                if ((contained3 = this.checkForUnsafeWildcards(tree, messageHeader + i + " nested: ", lowerBound, state)) != Description.NO_MATCH) {
                    return contained3;
                }
            } else if (arg instanceof Type.WildcardType && (wildcardType = (Type.WildcardType)arg).getExtendsBound() != null) {
                Description contained2 = this.checkForUnsafeWildcards(tree, messageHeader + i + " nested: ", wildcardType.getExtendsBound(), state);
                if (contained2 != Description.NO_MATCH) {
                    return contained2;
                }
            } else {
                Description contained2 = this.checkForUnsafeWildcards(tree, messageHeader + i + " nested: ", arg, state);
                if (contained2 != Description.NO_MATCH) {
                    return contained2;
                }
            }
            ++i;
        }
        if (targetType instanceof Type.IntersectionClassType) {
            Type.IntersectionClassType intersectionClassType = (Type.IntersectionClassType)targetType;
            for (Type type : intersectionClassType.getExplicitComponents()) {
                contained = this.checkForUnsafeWildcards(tree, messageHeader + "bound ", type, state);
                if (contained == Description.NO_MATCH) continue;
                return contained;
            }
        }
        if (targetType instanceof Type.UnionClassType) {
            Type.UnionClassType unionClassType = (Type.UnionClassType)targetType;
            for (Type type : unionClassType.getAlternativeTypes()) {
                contained = this.checkForUnsafeWildcards(tree, messageHeader + "alternative ", type, state);
                if (contained == Description.NO_MATCH) continue;
                return contained;
            }
        }
        return Description.NO_MATCH;
    }
}

