/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.matchers.Description;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="HTML entities in @code/@literal tags will appear literally in the rendered javadoc.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class EscapedEntity
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Pattern HTML_ENTITY = Pattern.compile("&[a-z0-9]+;|&#[0-9]+;|&#x[0-9a-f]+;", 2);

    public Description matchClass(ClassTree classTree, VisitorState state) {
        return this.handle(Utils.getDocTreePath(state), state);
    }

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        return this.handle(Utils.getDocTreePath(state), state);
    }

    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        return this.handle(Utils.getDocTreePath(state), state);
    }

    private Description handle(@Nullable DocTreePath path, VisitorState state) {
        if (path == null) {
            return Description.NO_MATCH;
        }
        new Scanner(state).scan(path, null);
        return Description.NO_MATCH;
    }

    private final class Scanner
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;

        private Scanner(VisitorState state) {
            this.state = state;
        }

        @Override
        public Void visitLiteral(LiteralTree node, Void unused) {
            Matcher matcher = HTML_ENTITY.matcher(node.getBody().getBody());
            if (matcher.find()) {
                this.state.reportMatch(EscapedEntity.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).build());
            }
            return (Void)super.visitLiteral(node, null);
        }
    }
}

