/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import java.util.List;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="This loop can be replaced with an enhanced for loop.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class ForEachIterable
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Matcher<ExpressionTree> HAS_NEXT = Matchers.instanceMethod().onDescendantOf("java.util.Iterator").named("hasNext");
    private static final Matcher<ExpressionTree> NEXT = Matchers.instanceMethod().onDescendantOf("java.util.Iterator").named("next");
    private static final Matcher<ExpressionTree> ITERATOR = Matchers.instanceMethod().onDescendantOf("java.lang.Iterable").named("iterator").withNoParameters();

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (!ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree.getType()), (Type)state.getSymtab().iteratorType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof BlockTree) {
            BlockTree blockTree = (BlockTree)parent;
            return this.matchWhile(tree, blockTree, state);
        }
        if (parent instanceof ForLoopTree) {
            ForLoopTree forLoopTree = (ForLoopTree)parent;
            return this.matchFor(tree, forLoopTree, state);
        }
        return Description.NO_MATCH;
    }

    private Description matchFor(VariableTree tree, ForLoopTree forTree, VisitorState state) {
        List<? extends StatementTree> initializer = forTree.getInitializer();
        if (initializer.size() != 1 || !((StatementTree)Iterables.getOnlyElement(initializer)).equals(tree)) {
            return Description.NO_MATCH;
        }
        if (!forTree.getUpdate().isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.match(tree, state, ASTHelpers.getStartPosition((Tree)forTree), forTree.getCondition(), forTree.getStatement());
    }

    private Description matchWhile(VariableTree tree, BlockTree blockTree, VisitorState state) {
        List<? extends StatementTree> statements = blockTree.getStatements();
        int nextIdx = statements.indexOf(tree) + 1;
        if (nextIdx >= statements.size()) {
            return Description.NO_MATCH;
        }
        StatementTree next = statements.get(nextIdx);
        if (!(next instanceof WhileLoopTree)) {
            return Description.NO_MATCH;
        }
        WhileLoopTree whileLoop = (WhileLoopTree)next;
        Symbol.VarSymbol iterator = ASTHelpers.getSymbol((VariableTree)tree);
        for (int i = nextIdx + 1; i < statements.size(); ++i) {
            if (this.findUses(state, statements.get(i), iterator).isEmpty()) continue;
            return Description.NO_MATCH;
        }
        return this.match(tree, state, ASTHelpers.getStartPosition((Tree)tree), whileLoop.getCondition(), whileLoop.getStatement());
    }

    private Description match(VariableTree tree, VisitorState state, int startPosition, ExpressionTree condition, StatementTree body) {
        ExpressionTree iterableExprNode;
        String replacement;
        if (tree.getInitializer() == null || !ITERATOR.matches((Tree)tree.getInitializer(), state)) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol iterator = ASTHelpers.getSymbol((VariableTree)tree);
        if (!ForEachIterable.isHasNext(iterator, ASTHelpers.stripParentheses((ExpressionTree)condition), state)) {
            return Description.NO_MATCH;
        }
        ImmutableList<TreePath> uses = this.findUses(state, body, iterator);
        if (uses.size() != 1 || !uses.stream().allMatch(p -> ForEachIterable.isNext(tree, state, p))) {
            return Description.NO_MATCH;
        }
        Type iteratorType = state.getTypes().asSuper(ASTHelpers.getType((Tree)tree.getType()), state.getSymtab().iteratorType.tsym);
        if (iteratorType == null || iteratorType.getTypeArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        VariableTree existingVariable = ForEachIterable.existingVariable(iterator, body, state);
        if (existingVariable != null) {
            replacement = existingVariable.getName().toString();
            fix.delete((Tree)existingVariable);
        } else {
            replacement = "element";
            uses.forEach(p -> {
                TreePath path = p.getParentPath().getParentPath();
                switch (path.getParentPath().getLeaf().getKind()) {
                    case EXPRESSION_STATEMENT: {
                        fix.delete(path.getParentPath().getLeaf());
                        break;
                    }
                    default: {
                        fix.replace(path.getLeaf(), replacement);
                    }
                }
            });
        }
        Type elementType = (Type)Iterables.getOnlyElement(iteratorType.getTypeArguments());
        if (elementType.hasTag(TypeTag.WILDCARD)) {
            elementType = ASTHelpers.getUpperBound((Type)elementType, (Types)state.getTypes());
        }
        String iterableExpr = (iterableExprNode = ASTHelpers.getReceiver((ExpressionTree)tree.getInitializer())) != null ? state.getSourceForNode((Tree)iterableExprNode) : "this";
        fix.replace(startPosition, ASTHelpers.getStartPosition((Tree)body), String.format("for (%s %s : %s) ", SuggestedFixes.prettyType((VisitorState)state, (SuggestedFix.Builder)fix, (Type)elementType), replacement, iterableExpr));
        return this.describeMatch(tree, (Fix)fix.build());
    }

    private ImmutableList<TreePath> findUses(VisitorState state, StatementTree body, final Symbol.VarSymbol iterator) {
        final ImmutableList.Builder uses = ImmutableList.builder();
        new TreePathScanner<Void, Void>(this){
            final /* synthetic */ ForEachIterable this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
                if (iterator.equals(ASTHelpers.getSymbol((Tree)identifierTree))) {
                    uses.add((Object)this.getCurrentPath());
                }
                return (Void)super.visitIdentifier(identifierTree, null);
            }
        }.scan(state.withPath(new TreePath(state.getPath().getParentPath(), body)).getPath(), (Void)null);
        return uses.build();
    }

    private static @Nullable VariableTree existingVariable(Symbol.VarSymbol varSymbol, StatementTree body, VisitorState state) {
        if (!(body instanceof BlockTree)) {
            return null;
        }
        BlockTree blockTree = (BlockTree)body;
        List<? extends StatementTree> statements = blockTree.getStatements();
        if (statements.isEmpty()) {
            return null;
        }
        StatementTree first = statements.iterator().next();
        if (!(first instanceof VariableTree)) {
            return null;
        }
        VariableTree variableTree = (VariableTree)first;
        if (variableTree.getInitializer() == null) {
            return null;
        }
        if (!NEXT.matches((Tree)variableTree.getInitializer(), state)) {
            return null;
        }
        if (!varSymbol.equals(ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)variableTree.getInitializer())))) {
            return null;
        }
        return variableTree;
    }

    private static boolean isNext(VariableTree tree, VisitorState state, TreePath p) {
        Tree parentTree = p.getParentPath().getLeaf();
        if (!(parentTree instanceof ExpressionTree)) {
            return false;
        }
        ExpressionTree parent = (ExpressionTree)parentTree;
        return NEXT.matches((Tree)parent, state) && ASTHelpers.getSymbol((VariableTree)tree).equals(ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)parent)));
    }

    private static boolean isHasNext(Symbol.VarSymbol iterator, ExpressionTree condition, VisitorState state) {
        return HAS_NEXT.matches((Tree)condition, state) && iterator.equals(ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)condition)));
    }
}

