/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import javax.lang.model.element.ElementKind;

@BugPattern(name="CompileTimeConstant", summary="Non-compile-time constant expression passed to parameter with @CompileTimeConstant type annotation.", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.ERROR)
public class CompileTimeConstantChecker
extends BugChecker
implements BugChecker.LambdaExpressionTreeMatcher,
BugChecker.MemberReferenceTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.VariableTreeMatcher,
BugChecker.AssignmentTreeMatcher {
    private static final String DID_YOU_MEAN_FINAL_FMT_MESSAGE = " Did you mean to make '%s' final?";
    private final Matcher<ExpressionTree> compileTimeConstExpressionMatcher = CompileTimeConstantExpressionMatcher.instance();

    private Description matchArguments(VisitorState state, Symbol.MethodSymbol calleeSymbol, Iterator<? extends ExpressionTree> actualParams) {
        Symbol.VarSymbol lastFormalParam = null;
        Iterator iterator = ((List)calleeSymbol.getParameters()).iterator();
        while (iterator.hasNext()) {
            Symbol.VarSymbol formalParam;
            lastFormalParam = formalParam = (Symbol.VarSymbol)iterator.next();
            if (!actualParams.hasNext()) {
                return Description.NO_MATCH;
            }
            ExpressionTree actualParam = actualParams.next();
            if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)formalParam) || this.compileTimeConstExpressionMatcher.matches((Tree)actualParam, state)) continue;
            return this.handleMatch(actualParam, state);
        }
        if (lastFormalParam == null) {
            return Description.NO_MATCH;
        }
        if (!calleeSymbol.isVarArgs()) {
            return Description.NO_MATCH;
        }
        if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)lastFormalParam)) {
            return Description.NO_MATCH;
        }
        while (actualParams.hasNext()) {
            ExpressionTree actualParam = actualParams.next();
            if (this.compileTimeConstExpressionMatcher.matches((Tree)actualParam, state)) continue;
            return this.handleMatch(actualParam, state);
        }
        return Description.NO_MATCH;
    }

    private Description handleMatch(ExpressionTree actualParam, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)actualParam);
        if (!(symbol instanceof Symbol.VarSymbol)) {
            return this.describeMatch(actualParam);
        }
        Symbol.VarSymbol var = (Symbol.VarSymbol)symbol;
        if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)var)) {
            return this.describeMatch(actualParam);
        }
        return this.buildDescription(actualParam).setMessage(this.message() + String.format(DID_YOU_MEAN_FINAL_FMT_MESSAGE, var.getSimpleName())).build();
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((NewClassTree)tree);
        return this.matchArguments(state, sym, tree.getArguments().iterator());
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        return this.matchArguments(state, sym, tree.getArguments().iterator());
    }

    public Description matchMethod(MethodTree node, VisitorState state) {
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodTree)node);
        java.util.List<Integer> compileTimeConstantAnnotationIndexes = CompileTimeConstantChecker.getAnnotatedParams(method.getParameters(), state);
        if (compileTimeConstantAnnotationIndexes.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.checkSuperMethods(node, state, compileTimeConstantAnnotationIndexes, ASTHelpers.findSuperMethods((Symbol.MethodSymbol)method, (Types)state.getTypes()));
    }

    public Description matchMemberReference(MemberReferenceTree node, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MemberReferenceTree)node);
        java.util.List<Integer> compileTimeConstantAnnotationIndexes = CompileTimeConstantChecker.getAnnotatedParams(sym.getParameters(), state);
        if (compileTimeConstantAnnotationIndexes.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.checkLambda(node, state, compileTimeConstantAnnotationIndexes);
    }

    public Description matchLambdaExpression(LambdaExpressionTree node, VisitorState state) {
        java.util.List<Integer> compileTimeConstantAnnotationIndexes = CompileTimeConstantChecker.getAnnotatedParams((java.util.List)node.getParameters().stream().map(ASTHelpers::getSymbol).collect(ImmutableList.toImmutableList()), state);
        if (compileTimeConstantAnnotationIndexes.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.checkLambda(node, state, compileTimeConstantAnnotationIndexes);
    }

    public Description matchVariable(VariableTree node, VisitorState state) {
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)node);
        if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)symbol)) {
            return Description.NO_MATCH;
        }
        switch (((Symbol)symbol).getKind()) {
            case PARAMETER: {
                return Description.NO_MATCH;
            }
            case FIELD: {
                break;
            }
            default: {
                throw new AssertionError((Object)((Symbol)symbol).getKind());
            }
        }
        if ((symbol.flags() & 0x10L) == 0L) {
            return this.buildDescription(node).setMessage(this.message() + String.format(DID_YOU_MEAN_FINAL_FMT_MESSAGE, ((Symbol)symbol).getSimpleName())).build();
        }
        if (node.getInitializer() != null && !this.compileTimeConstExpressionMatcher.matches((Tree)node.getInitializer(), state)) {
            return this.describeMatch(node.getInitializer());
        }
        return Description.NO_MATCH;
    }

    public Description matchAssignment(AssignmentTree node, VisitorState state) {
        ExpressionTree variable = node.getVariable();
        ExpressionTree expression = node.getExpression();
        Symbol assignedSymbol = ASTHelpers.getSymbol((Tree)variable);
        if (assignedSymbol == null || assignedSymbol.owner == null) {
            return Description.NO_MATCH;
        }
        if (assignedSymbol.owner.getKind() != ElementKind.CLASS && assignedSymbol.owner.getKind() != ElementKind.ENUM) {
            return Description.NO_MATCH;
        }
        if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)assignedSymbol)) {
            return Description.NO_MATCH;
        }
        if (this.compileTimeConstExpressionMatcher.matches((Tree)expression, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(expression);
    }

    private Description checkLambda(ExpressionTree node, VisitorState state, java.util.List<Integer> compileTimeConstantAnnotationIndexes) {
        Symbol.MethodSymbol descriptorSymbol = (Symbol.MethodSymbol)state.getTypes().findDescriptorSymbol(ASTHelpers.getType((Tree)node).tsym);
        ImmutableSet.Builder methods = ImmutableSet.builder();
        methods.add((Object)descriptorSymbol);
        methods.addAll((Iterable)ASTHelpers.findSuperMethods((Symbol.MethodSymbol)descriptorSymbol, (Types)state.getTypes()));
        return this.checkSuperMethods(node, state, compileTimeConstantAnnotationIndexes, (Iterable<Symbol.MethodSymbol>)methods.build());
    }

    private static java.util.List<Integer> getAnnotatedParams(java.util.List<Symbol.VarSymbol> params, VisitorState state) {
        ArrayList<Integer> compileTimeConstantAnnotationIndexes = new ArrayList<Integer>();
        for (int i = 0; i < params.size(); ++i) {
            if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)params.get(i))) continue;
            compileTimeConstantAnnotationIndexes.add(i);
        }
        return compileTimeConstantAnnotationIndexes;
    }

    private Description checkSuperMethods(Tree node, VisitorState state, java.util.List<Integer> compileTimeConstantAnnotationIndexes, Iterable<Symbol.MethodSymbol> superMethods) {
        for (Symbol.MethodSymbol superMethod : superMethods) {
            for (Integer index : compileTimeConstantAnnotationIndexes) {
                if (CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)((Symbol)((List)superMethod.getParameters()).get(index)))) continue;
                return this.buildDescription(node).setMessage("Method with @CompileTimeConstant parameter can't override method without it.").build();
            }
        }
        return Description.NO_MATCH;
    }
}

