/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(summary="The use of an assignment expression can be surprising and hard to read; consider factoring out the assignment to a separate statement.", severity=BugPattern.SeverityLevel.WARNING)
public final class AssignmentExpression
extends BugChecker
implements BugChecker.AssignmentTreeMatcher {
    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof ExpressionStatementTree) {
            return Description.NO_MATCH;
        }
        if (parent instanceof AnnotationTree) {
            return Description.NO_MATCH;
        }
        if (parent instanceof LambdaExpressionTree) {
            return Description.NO_MATCH;
        }
        if (parent instanceof ParenthesizedTree && state.getPath().getParentPath().getParentPath().getLeaf() instanceof BinaryTree) {
            return Description.NO_MATCH;
        }
        if (AssignmentExpression.isDuplicateAssignment(tree, parent)) {
            return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)state.getSourceForNode((Tree)tree.getExpression())));
        }
        if (parent instanceof AssignmentTree) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    private static boolean isDuplicateAssignment(AssignmentTree tree, Tree parent) {
        Symbol symbol;
        if (!(tree.getVariable() instanceof IdentifierTree) || !((symbol = ASTHelpers.getSymbol((Tree)tree.getVariable())) instanceof Symbol.VarSymbol)) {
            return false;
        }
        Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
        return switch (parent.getKind()) {
            case Tree.Kind.ASSIGNMENT -> {
                IdentifierTree identifierTree;
                ExpressionTree var4_4 = ((AssignmentTree)parent).getVariable();
                if (var4_4 instanceof IdentifierTree && varSymbol.equals(ASTHelpers.getSymbol((Tree)(identifierTree = (IdentifierTree)var4_4)))) {
                    yield true;
                }
                yield false;
            }
            case Tree.Kind.VARIABLE -> varSymbol.equals(ASTHelpers.getSymbol((VariableTree)((VariableTree)parent)));
            default -> false;
        };
    }
}

