/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.escape.ArrayBasedCharEscaper;
import com.google.common.escape.CharEscaper;
import java.util.Map;

public final class SourceCodeEscapers {
    private static final char PRINTABLE_ASCII_MIN = ' ';
    private static final char PRINTABLE_ASCII_MAX = '~';
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private static final CharEscaper JAVA_CHAR_ESCAPER = new JavaCharEscaper((Map<Character, String>)ImmutableMap.of((Object)Character.valueOf('\b'), (Object)"\\b", (Object)Character.valueOf('\f'), (Object)"\\f", (Object)Character.valueOf('\n'), (Object)"\\n", (Object)Character.valueOf('\r'), (Object)"\\r", (Object)Character.valueOf('\t'), (Object)"\\t", (Object)Character.valueOf('\"'), (Object)"\\\"", (Object)Character.valueOf('\\'), (Object)"\\\\", (Object)Character.valueOf('\''), (Object)"\\'"));
    private static final CharEscaper JAVA_TEXT_BLOCK_ESCAPER = new JavaCharEscaper((Map<Character, String>)ImmutableMap.of((Object)Character.valueOf('\b'), (Object)"\\b", (Object)Character.valueOf('\f'), (Object)"\\f", (Object)Character.valueOf('\n'), (Object)"\\n", (Object)Character.valueOf('\r'), (Object)"\\r", (Object)Character.valueOf('\t'), (Object)"\\t", (Object)Character.valueOf('\\'), (Object)"\\\\"));

    private SourceCodeEscapers() {
    }

    public static CharEscaper javaCharEscaper() {
        return JAVA_CHAR_ESCAPER;
    }

    public static CharEscaper getJavaTextBlockEscaper() {
        return JAVA_TEXT_BLOCK_ESCAPER;
    }

    private static char[] asUnicodeHexEscape(char c) {
        char[] r = new char[6];
        r[0] = 92;
        r[1] = 117;
        r[5] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[4] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[3] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[2] = HEX_DIGITS[c & 0xF];
        return r;
    }

    private static class JavaCharEscaper
    extends ArrayBasedCharEscaper {
        JavaCharEscaper(Map<Character, String> replacements) {
            super(replacements, ' ', '~');
        }

        protected char[] escapeUnsafe(char c) {
            return SourceCodeEscapers.asUnicodeHexEscape(c);
        }
    }
}

