/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import proguard.util.StringUtil;

public class ZipOutput {
    private static final int MAGIC_LOCAL_FILE_HEADER = 67324752;
    private static final int MAGIC_CENTRAL_DIRECTORY_FILE_HEADER = 33639248;
    private static final int MAGIC_END_OF_CENTRAL_DIRECTORY = 101010256;
    private static final int MAGIC_ZIP64_END_OF_CENTRAL_DIRECTORY = 101075792;
    private static final int MAGIC_ZIP64_END_OF_CENTRAL_DIRECTORY_LOCATOR = 117853008;
    private static final int MAGIC_ZIP64_EXTENDED_EXTRA_INFORMATION_FIELD = 1;
    private static final int VERSION = 10;
    private static final int GENERAL_PURPOSE_FLAG = 0;
    private static final int METHOD_UNCOMPRESSED = 0;
    private static final int METHOD_COMPRESSED = 8;
    private static final int ZIP64_MIN_VERSION = 45;
    private static final int ZIP64_EXTENDED_EXTRA_INFORMATION_FIELD_HEADER_SIZE = 4;
    private static final int ZIP64_EXTENDED_SMALL_EXTRA_INFORMATION_FIELD_SIZE = 16;
    private static final int ZIP64_EXTENDED_LARGE_EXTRA_INFORMATION_FIELD_SIZE = 24;
    private static final long ZIP64_FIELD_TOO_SMALL_32BIT = -1L;
    private static final boolean DEBUG = false;
    protected LargeDataOutputStream outputStream;
    private final int uncompressedAlignment;
    private final String comment;
    private final boolean useZip64;
    private List<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
    private Set<String> zipEntryNames = new HashSet<String>();

    public ZipOutput(OutputStream outputStream) {
        this(outputStream, 1);
    }

    public ZipOutput(OutputStream outputStream, boolean useZip64) {
        this(outputStream, 1, useZip64, null);
    }

    public ZipOutput(OutputStream outputStream, int uncompressedAlignment) {
        this(outputStream, uncompressedAlignment, false, null);
    }

    public ZipOutput(OutputStream outputStream, boolean useZip64, int uncompressedAlignment) {
        this(outputStream, uncompressedAlignment, useZip64, null);
    }

    public ZipOutput(OutputStream outputStream, int uncompressedAlignment, boolean useZip64, String comment) {
        this.outputStream = new LargeDataOutputStream(outputStream);
        this.uncompressedAlignment = uncompressedAlignment;
        this.useZip64 = useZip64;
        this.comment = comment;
    }

    public ZipOutput(OutputStream outputStream, byte[] header, int uncompressedAlignment, boolean useZip64) throws IOException {
        this(outputStream, header, uncompressedAlignment, useZip64, null);
    }

    public ZipOutput(OutputStream outputStream, byte[] header, int uncompressedAlignment, boolean useZip64, String comment) throws IOException {
        this.outputStream = new LargeDataOutputStream(outputStream);
        this.uncompressedAlignment = uncompressedAlignment;
        this.useZip64 = useZip64;
        this.comment = comment;
        if (header != null) {
            outputStream.write(header);
        }
    }

    public OutputStream createOutputStream(String name, boolean compress, int modificationTime) throws IOException {
        return this.createOutputStream(name, compress, this.uncompressedAlignment, modificationTime, null, null);
    }

    public OutputStream createOutputStream(String name, boolean compress, int uncompressedAlignment, int modificationTime) throws IOException {
        return this.createOutputStream(name, compress, uncompressedAlignment, modificationTime, null, null);
    }

    public OutputStream createOutputStream(String name, boolean compress, int uncompressedAlignment, int modificationTime, byte[] extraField, String comment) throws IOException {
        if (!this.zipEntryNames.add(name)) {
            throw new IOException("Duplicate jar entry [" + name + "]");
        }
        ZipEntry entry = new ZipEntry(name, compress, uncompressedAlignment, modificationTime, extraField, comment);
        this.zipEntries.add(entry);
        return entry.createOutputStream();
    }

    public void close() throws IOException {
        long centralDirectoryOffset = this.writeStartOfCentralDirectory();
        this.close(centralDirectoryOffset);
    }

    public void close(long centralDirectoryOffset) throws IOException {
        long centralDirectorySize = this.writeEntriesOfCentralDirectory();
        if (this.useZip64) {
            long zip64EndOfCentralDirectoryOffset = this.outputStream.getLongSize();
            this.writeZip64EndOfCentralDirectory(centralDirectoryOffset, centralDirectorySize);
            this.writeZip64EndOfCentralDirectoryLocator(zip64EndOfCentralDirectoryOffset);
        }
        this.writeEndOfCentralDirectory(centralDirectoryOffset, centralDirectorySize);
        this.outputStream.close();
        this.outputStream = null;
        this.zipEntries = null;
        this.zipEntryNames = null;
    }

    protected long size() {
        return this.outputStream.getLongSize();
    }

    protected long writeStartOfCentralDirectory() {
        return this.outputStream.getLongSize();
    }

    protected long writeEntriesOfCentralDirectory() throws IOException {
        long offset = this.outputStream.getLongSize();
        for (int index = 0; index < this.zipEntries.size(); ++index) {
            ZipEntry entry = this.zipEntries.get(index);
            entry.writeCentralDirectoryFileHeader();
        }
        return this.outputStream.getLongSize() - offset;
    }

    protected void writeEndOfCentralDirectory(long centralDirectoryOffset, long centralDirectorySize) throws IOException {
        this.writeInt(101010256);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.zipEntries.size());
        this.writeShort(this.zipEntries.size());
        this.writeInt(centralDirectorySize);
        this.writeInt(this.useZip64 ? -1L : centralDirectoryOffset);
        if (this.comment == null) {
            this.writeShort(0);
        } else {
            byte[] commentBytes = StringUtil.getModifiedUtf8Bytes(this.comment);
            this.writeShort(commentBytes.length);
            this.outputStream.write(commentBytes);
        }
    }

    protected void writeZip64EndOfCentralDirectory(long centralDirectoryOffset, long centralDirectorySize) throws IOException {
        this.writeInt(101075792);
        this.writeLong(44L);
        this.writeShort(45);
        this.writeShort(45);
        this.writeInt(0);
        this.writeInt(0);
        this.writeLong(this.zipEntries.size());
        this.writeLong(this.zipEntries.size());
        this.writeLong(centralDirectorySize);
        this.writeLong(centralDirectoryOffset);
    }

    protected void writeZip64EndOfCentralDirectoryLocator(long zip64CentralDirectoryOffset) throws IOException {
        this.writeInt(117853008);
        this.writeInt(0);
        this.writeLong(zip64CentralDirectoryOffset);
        this.writeInt(1);
    }

    protected void writeShort(int value) throws IOException {
        this.outputStream.write(value);
        this.outputStream.write(value >>> 8);
    }

    protected void writeInt(int value) throws IOException {
        this.outputStream.write(value);
        this.outputStream.write(value >>> 8);
        this.outputStream.write(value >>> 16);
        this.outputStream.write(value >>> 24);
    }

    protected void writeInt(long value) throws IOException {
        this.outputStream.write((int)value);
        this.outputStream.write((int)(value >>> 8));
        this.outputStream.write((int)(value >>> 16));
        this.outputStream.write((int)(value >>> 24));
    }

    protected void writeLong(long value) throws IOException {
        this.outputStream.write((int)value);
        this.outputStream.write((int)(value >>> 8));
        this.outputStream.write((int)(value >>> 16));
        this.outputStream.write((int)(value >>> 24));
        this.outputStream.write((int)(value >>> 32));
        this.outputStream.write((int)(value >>> 40));
        this.outputStream.write((int)(value >>> 48));
        this.outputStream.write((int)(value >>> 56));
    }

    public static void main(String[] args) {
        try {
            ZipOutput output = new ZipOutput(new FileOutputStream(args[0]), null, 4, false, "Main file comment");
            PrintWriter printWriter1 = new PrintWriter(output.createOutputStream("file1.txt", false, 1, 0, new byte[]{52, 18, 4, 0, 72, 101, 108, 108, 111}, "Comment"));
            printWriter1.println("This is file 1.");
            printWriter1.println("Hello, world!");
            printWriter1.close();
            PrintWriter printWriter2 = new PrintWriter(output.createOutputStream("file2.txt", true, 1, 0, null, "Another comment"));
            printWriter2.println("This is file 2.");
            printWriter2.println("Hello, world!");
            printWriter2.close();
            PrintWriter printWriter3 = new PrintWriter(output.createOutputStream("file3.txt", false, 1, 0, null, "Last comment"));
            printWriter3.println("This is file 3.");
            printWriter3.println("Hello, world!");
            printWriter3.close();
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class LargeDataOutputStream
    extends DataOutputStream {
        private long written = 0L;

        public LargeDataOutputStream(OutputStream out) {
            super(out);
        }

        public long getLongSize() {
            return this.written;
        }

        @Override
        public synchronized void write(int b) throws IOException {
            super.write(b);
            ++this.written;
        }

        @Override
        public void write(byte[] b) throws IOException {
            super.write(b);
            this.written += (long)b.length;
        }
    }

    private class ZipEntry {
        private boolean compressed;
        private int uncompressedAlignment;
        private int modificationTime;
        private int crc;
        private long compressedSize;
        private long uncompressedSize;
        private long offset;
        private String name;
        private byte[] extraField;
        private String comment;

        private ZipEntry(String name, boolean compressed, int uncompressedAlignment, int modificationTime, byte[] extraField, String comment) {
            this.name = name;
            this.compressed = compressed;
            this.uncompressedAlignment = uncompressedAlignment;
            this.modificationTime = modificationTime;
            this.extraField = extraField;
            this.comment = comment;
        }

        public OutputStream createOutputStream() throws IOException {
            return this.compressed ? new CompressedZipEntryOutputStream() : new UncompressedZipEntryOutputStream();
        }

        private void writeLocalFileHeader() throws IOException {
            long dataOffset;
            boolean useZip64ExtraField = ZipOutput.this.useZip64 && (this.compressedSize >> 32 > 0L || this.uncompressedSize >> 32 > 0L);
            ZipOutput.this.writeInt(67324752);
            ZipOutput.this.writeShort(ZipOutput.this.useZip64 ? 45 : 10);
            ZipOutput.this.writeShort(0);
            ZipOutput.this.writeShort(this.compressed ? 8 : 0);
            ZipOutput.this.writeInt(this.modificationTime);
            ZipOutput.this.writeInt(this.crc);
            ZipOutput.this.writeInt(useZip64ExtraField ? -1L : this.compressedSize);
            ZipOutput.this.writeInt(useZip64ExtraField ? -1L : this.uncompressedSize);
            byte[] nameBytes = StringUtil.getModifiedUtf8Bytes(this.name);
            int nameLength = nameBytes.length;
            int extraFieldLength = (useZip64ExtraField ? 20 : 0) + (this.extraField != null ? this.extraField.length : 0);
            ZipOutput.this.writeShort(nameLength);
            int alignmentDelta = 0;
            if (!this.compressed && (alignmentDelta = (int)((dataOffset = ZipOutput.this.outputStream.getLongSize() + 2L + (long)nameLength + (long)extraFieldLength) % (long)this.uncompressedAlignment)) > 0) {
                alignmentDelta = this.uncompressedAlignment - alignmentDelta;
            }
            ZipOutput.this.writeShort(extraFieldLength + alignmentDelta);
            ZipOutput.this.outputStream.write(nameBytes);
            if (useZip64ExtraField) {
                ZipOutput.this.writeShort(1);
                ZipOutput.this.writeShort(16);
                ZipOutput.this.writeLong(this.uncompressedSize);
                ZipOutput.this.writeLong(this.compressedSize);
            }
            if (this.extraField != null) {
                ZipOutput.this.outputStream.write(this.extraField);
            }
            if (alignmentDelta > 0) {
                ZipOutput.this.outputStream.write(new byte[alignmentDelta]);
            }
        }

        public void writeCentralDirectoryFileHeader() throws IOException {
            boolean useZip64ExtraField = ZipOutput.this.useZip64 && (this.compressedSize >> 32 > 0L || this.uncompressedSize >> 32 > 0L || this.offset >> 32 > 0L);
            ZipOutput.this.writeInt(33639248);
            ZipOutput.this.writeShort(ZipOutput.this.useZip64 ? 45 : 10);
            ZipOutput.this.writeShort(ZipOutput.this.useZip64 ? 45 : 10);
            ZipOutput.this.writeShort(0);
            ZipOutput.this.writeShort(this.compressed ? 8 : 0);
            ZipOutput.this.writeInt(this.modificationTime);
            ZipOutput.this.writeInt(this.crc);
            ZipOutput.this.writeInt(useZip64ExtraField ? -1L : this.compressedSize);
            ZipOutput.this.writeInt(useZip64ExtraField ? -1L : this.uncompressedSize);
            byte[] nameBytes = StringUtil.getModifiedUtf8Bytes(this.name);
            byte[] commentBytes = this.comment == null ? null : StringUtil.getModifiedUtf8Bytes(this.comment);
            ZipOutput.this.writeShort(nameBytes.length);
            int extraFieldLength = (useZip64ExtraField ? 28 : 0) + (this.extraField != null ? this.extraField.length : 0);
            ZipOutput.this.writeShort(extraFieldLength);
            ZipOutput.this.writeShort(commentBytes == null ? 0 : commentBytes.length);
            ZipOutput.this.writeShort(0);
            ZipOutput.this.writeShort(0);
            ZipOutput.this.writeInt(0);
            ZipOutput.this.writeInt(useZip64ExtraField ? -1L : this.offset);
            ZipOutput.this.outputStream.write(nameBytes);
            if (ZipOutput.this.useZip64 && useZip64ExtraField) {
                ZipOutput.this.writeShort(1);
                ZipOutput.this.writeShort(24);
                ZipOutput.this.writeLong(this.uncompressedSize);
                ZipOutput.this.writeLong(this.compressedSize);
                ZipOutput.this.writeLong(this.offset);
            }
            if (this.extraField != null) {
                ZipOutput.this.outputStream.write(this.extraField);
            }
            if (commentBytes != null) {
                ZipOutput.this.outputStream.write(commentBytes);
            }
        }

        private class CompressedZipEntryOutputStream
        extends DeflaterOutputStream {
            private CRC32 crc32;

            private CompressedZipEntryOutputStream() {
                super((OutputStream)new ByteArrayOutputStream(16384), new Deflater(9, true), 1024);
                this.crc32 = new CRC32();
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                super.write(b, off, len);
                this.crc32.update(b, off, len);
                ZipEntry.this.uncompressedSize = ZipEntry.this.uncompressedSize + (long)len;
            }

            @Override
            public void close() throws IOException {
                super.finish();
                this.def.end();
                super.close();
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.out;
                byte[] compressedBytes = byteArrayOutputStream.toByteArray();
                ZipEntry.this.offset = ZipOutput.this.outputStream.getLongSize();
                ZipEntry.this.crc = (int)this.crc32.getValue();
                ZipEntry.this.compressedSize = compressedBytes.length;
                ZipEntry.this.writeLocalFileHeader();
                ZipOutput.this.outputStream.write(compressedBytes);
            }
        }

        private class UncompressedZipEntryOutputStream
        extends ByteArrayOutputStream {
            private CRC32 crc32;

            private UncompressedZipEntryOutputStream() {
                super(16384);
                this.crc32 = new CRC32();
            }

            @Override
            public synchronized void write(int b) {
                super.write(b);
                this.crc32.update(b);
            }

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                super.write(b, off, len);
                this.crc32.update(b, off, len);
            }

            @Override
            public void close() throws IOException {
                super.close();
                byte[] bytes = super.toByteArray();
                ZipEntry.this.offset = ZipOutput.this.outputStream.getLongSize();
                ZipEntry.this.crc = (int)this.crc32.getValue();
                ZipEntry.this.compressedSize = bytes.length;
                ZipEntry.this.uncompressedSize = bytes.length;
                ZipEntry.this.writeLocalFileHeader();
                ZipOutput.this.outputStream.write(bytes);
            }
        }
    }
}

