/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Objects;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.util.ArrayUtil;

public class LibraryClassEditor {
    private static final boolean DEBUG = false;
    private final LibraryClass targetClass;

    public LibraryClassEditor(LibraryClass targetClass) {
        this.targetClass = targetClass;
    }

    public void addInterface(String interfaceName, Clazz referencedInterface) {
        this.targetClass.interfaceNames = ArrayUtil.add(this.targetClass.interfaceNames, this.targetClass.interfaceNames.length + 1, interfaceName);
        this.targetClass.interfaceClasses = ArrayUtil.add(this.targetClass.interfaceClasses, this.targetClass.interfaceClasses.length + 1, referencedInterface);
    }

    public void removeInterface(String interfaceName) {
        ArrayUtil.remove(this.targetClass.interfaceNames, this.targetClass.interfaceNames.length, this.findInterfaceIndex(interfaceName));
        ArrayUtil.remove(this.targetClass.interfaceClasses, this.targetClass.interfaceClasses.length, this.findInterfaceClazzIndex(interfaceName));
    }

    private int findInterfaceIndex(String interfaceName) {
        String[] interfacesNames = this.targetClass.interfaceNames;
        for (int index = 0; index < interfacesNames.length; ++index) {
            if (!Objects.equals(interfacesNames[index], interfaceName)) continue;
            return index;
        }
        return interfacesNames.length;
    }

    private int findInterfaceClazzIndex(String interfaceName) {
        Clazz[] interfacesClasses = this.targetClass.interfaceClasses;
        for (int index = 0; index < interfacesClasses.length; ++index) {
            if (interfacesClasses[index] == null || !Objects.equals(interfacesClasses[index].getName(), interfaceName)) continue;
            return index;
        }
        return interfacesClasses.length;
    }

    public void addField(Field field) {
        this.targetClass.fields = (LibraryField[])ArrayUtil.add(this.targetClass.fields, this.targetClass.fields.length, field);
    }

    public void removeField(Field field) {
        ArrayUtil.remove(this.targetClass.fields, this.targetClass.fields.length, this.findFieldIndex(field));
    }

    private int findFieldIndex(Field field) {
        int fieldsCount = this.targetClass.fields.length;
        LibraryField[] fields = this.targetClass.fields;
        for (int index = 0; index < fieldsCount; ++index) {
            if (fields[index] == null || !fields[index].equals(field)) continue;
            return index;
        }
        return fieldsCount;
    }

    public void addMethod(Method method) {
        this.targetClass.methods = (LibraryMethod[])ArrayUtil.add(this.targetClass.methods, this.targetClass.methods.length, method);
    }

    public void removeMethod(Method method) {
        ArrayUtil.remove(this.targetClass.methods, this.targetClass.methods.length, this.findMethodIndex(method));
    }

    private int findMethodIndex(Method method) {
        int methodsCount = this.targetClass.methods.length;
        LibraryMethod[] methods = this.targetClass.methods;
        for (int index = 0; index < methodsCount; ++index) {
            if (methods[index] == null || !methods[index].equals(method)) continue;
            return index;
        }
        return methodsCount;
    }
}

